// -*- coding: utf-8; -*-
// (c) Copyright 2009, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#include <QApplication>
#include <QSettings>
#if 0 // This includes left here because we haven't tested all conditionals and platforms.
#include <QGridLayout>
#include <QVBoxLayout>
#include <QMenuBar>
#endif
#include <QStyleFactory>
#if 0
#include <QDebug>
#include <QUrl>
#include <QPainter>
#include <QPaintEvent>
#include <QFileDialog>
#endif
#include <QMessageBox>
#if 0
#include <QTextDocument>
#include <audiooutput.h>
#include <backendcapabilities.h>
#endif
#include "timeshop.hpp"
#if 0
#include "ui_timer_settings.h"
#include "ui_save_preset.h"
#endif

namespace Timeshop
{
  Time elapsed( const QDateTime& From, const QDateTime& To ) // Milliseconds From DateTime To DateTime
  {
    Time Days = From.date().daysTo( To.date() );
    return From.time().msecsTo( To.time() ) + Days * 24*60*60*1000;
  } // elapsed( const QDateTime&, const QDateTime& )
  QString format_time( Time TimeValue, int Precision )
  { //! \todo Make formatting better.
    QString Result;
    if( TimeValue < 0 )
    {
      Result += "-";
      TimeValue = -TimeValue;
    }
    int Hours = TimeValue / 1000;
    int Seconds = Hours % 60;
    Hours /= 60;
    int Minutes = Hours % 60;
    Hours /= 60;
    if( Hours > 0 )
    {
      Result = QString::number( Hours );
      if( Precision <= TimerSettings::Period::Minute )
      {
	Result += ':';
	if( Minutes < 10 )
	  Result += '0';
      }
    }
    if( Precision <= TimerSettings::Period::Minute )
    {
      if( Minutes > 0 || Hours > 0 )
      {
	Result += QString::number( Minutes );
	if( Precision <= TimerSettings::Period::Second )
	{
	  Result += ':';
	  if( Seconds < 10 )
	    Result += '0';
	}
      }
      if( Precision <= TimerSettings::Period::Second )
      {
	Result += QString::number( Seconds );
	if( Precision < TimerSettings::Period::Second )
	{
	  Result += '.';
	  int Fraction = TimeValue % 1000;
	  for( int I = -3; I < Precision; I++ )
	    Fraction /= 10;
	  QString Str = QString::number( Fraction );
	  for( int I = -Precision; I > Str.length(); I-- )
	    Result += '0';
	  Result += Str;
	}
      }
    } // Minutes
    if( Result.isEmpty() )
      Result = "0";
    return Result;
  } // format_time( Time )

  void StyleAction::set_style()
  {
    QApplication::setStyle( text() );
    // Store user preference
    QSettings().setValue( "Qt/Style", text() );
  } // set_style()

  StylesMenu::StylesMenu( const QString& Name, QWidget* Parent ) : QMenu( Name, Parent )
  {
    QStringList StylesAvail = QStyleFactory::keys();
    for( QStringList::const_iterator It = StylesAvail.begin(); It != StylesAvail.end(); It++ )
      addAction( new StyleAction( *It, this ) );
    addSeparator();
    connect( addAction( tr( "Reset" ) ), SIGNAL( triggered( bool ) ), SLOT( reset_style() ) );
  } // StylesMenu( const QString&, QWidget* )
  void StylesMenu::reset_style()
  {
    QApplication::setStyle( 0 ); // Don't work now, but did (or not?).
    // Store user preference
    QSettings().remove( "Qt/Style" );
  } // reset_style()

  AboutAction::AboutAction( const QString& Text0, const QString& Title, QWidget* Parent ) : QAction( Title, Parent ), Text( Text0 )
  {
    setMenuRole( QAction::AboutRole );
    connect( this, SIGNAL( triggered( bool ) ), SLOT( about() ) );
  } // AboutAction( const QString&, const QString&, QWidget* )
  void AboutAction::about()
  {
    QMessageBox::about( parentWidget(), text(), Text );
  } // about()
} // Timeshop
