// -*- coding: utf-8; -*-
// (c) Copyright 2009, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef TIMESHOP_MAEMO_PLAYBACK_HPP
#define TIMESHOP_MAEMO_PLAYBACK_HPP
#include <Phonon>
extern "C" {
#include <libmafw/mafw-source.h>
#include <libmafw/mafw-renderer.h>
#include <libmafw/mafw-registry.h>
#include <libmafw-shared/mafw-shared.h>
#include <libplayback/playback.h>
}
namespace Timeshop
{
  class Playback
  {
    void static request_handler_callback( pb_playback_t* PB, enum pb_state_e State, pb_req_t* Req, void* Data );
    void static state_hint_callback( pb_playback_t* PB, const int AllowedStates[], void* Data );
    void static state_reply_callback( pb_playback_t* PB, enum pb_state_e State, const char* Reason, pb_req_t* Req, void* Data );
    void static mute_state_callback( int Mute, const char* Error, void* Data );
  public:
    Playback( Phonon::MediaObject* Media0, pb_class_e Class = PB_CLASS_ALARM );
    ~Playback();
  protected:
    virtual void request_handler( enum pb_state_e State, pb_req_t* Req );
    virtual void state_hint( const int AllowedStates[] );
    virtual void state_reply( enum pb_state_e State, const char* Reason, pb_req_t* Req );
    Phonon::MediaObject* Media;
    DBusConnection* Connection;
    pb_playback_t* PlaybackObject;
  }; // Playback
} // Timeshop
#endif // TIMESHOP_MAEMO_PLAYBACK_HPP
