# (c) Copyright 2010, Николай Слободской (Nick Slobodsky)
# This file is part of Timeshop.
#
# Timeshop is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Timeshop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
#
VERSION = 0.3.1

TEMPLATE = lib
TARGET = timeshop
!maemo5|!contains( QT_CONFIG, hildon ) {
QT += phonon
}
DEFINES += TIMESHOP_LIB_SHARED

# Input
HEADERS += timeshop.hpp
SOURCES += core.cpp timeshop.cpp controllers.cpp displays.cpp stopwatches.cpp settings.cpp alarms.cpp utility.cpp
RESOURCES = timeshop.qrc
FORMS = timer_settings.ui save_preset.ui timer_finger.ui
maemo5|contains( QT_CONFIG, hildon ) {
FORMS += forms/mark_dialog.ui
CONFIG += link_pkgconfig
PKGCONFIG += mafw mafw-shared
SOURCES += mafw_alarm.cpp
# SOURCES += maemo_playback.cpp
}

#! \todo Move translation to separate langpack.
trans.target = lang/ru.qm
trans.depends = lang/ru.ts
trans.commands = $${QT_BIN_DIR}lrelease lib.pro
QMAKE_EXTRA_TARGETS += trans
QMAKE_CLEAN += $${trans.target}
PRE_TARGETDEPS += $${trans.target}
TRANSLATIONS = $${trans.depends}

unix {
isEmpty( PREFIX ) {
  PREFIX = /usr/local
}
DEFINES += TIMESHOP_DATADIR=\'\"$${PREFIX}/share/timeshop\"\'

LIBDIR = $${PREFIX}/lib
INCDIR = $${PREFIX}/include

target.path += $${LIBDIR}
INSTALLS += target

DEPENDPATH += .
INCLUDEPATH += .

headers.path = $${INCDIR}
headers.files = $${HEADERS}
# headers.extra = $(INSTALL_FILE) timeshop.hpp $(INSTALL_ROOT)$${INCDIR} )
INSTALLS += headers
}
