// -*- coding: utf-8; -*-
// (c) Copyright 2009, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#include <QDebug>
#include "timeshop.hpp"

namespace Timeshop
{
  const char QtController::Loader::Tag[] = "qt_controller";
  QtController::QtController( Client& Receiver0, QObject* Parent, Persistent::ID ObjectID0 ) : QObject( Parent ), Controller( Receiver0, ObjectID0 ) {}

  WidgetController::WidgetController( Client& Receiver0, QWidget* Parent, Persistent::ID ObjectID0 ) : QWidget( Parent ), Controller( Receiver0, ObjectID0 )
  { setObjectName( "Timeshop::WidgetController-" + QString::number( id() ) ); }
  bool WidgetController::load_element( QXmlStreamReader& Stream, Work* Root )
  {
    bool Result = false;
    qDebug() << "\tWidgetControl: Field:" << Stream.name();
    if( Loader::load_widget_field( Stream, this ) )
      Result = true;
    else
      Result = Super::load_element( Stream, Root );
    return Result;
  } // load_element( QXmlStreamReader&, Work* )
  void WidgetController::write_attributes( QXmlStreamWriter& Stream ) const
  {
    Super::write_attributes( Stream );
    Loader::write_parent_attribute( Stream, *this, "parent" );
  } // write_attributes( QXmlStreamWriter& ) const
  void WidgetController::write_elements( QXmlStreamWriter& Stream ) const
  {
    Super::write_elements( Stream );
    Loader::write_widget_fields( Stream, this );
  } // write_elements( QXmlStreamWriter& ) const
 
  Persistent* ButtonBoxController::Loader::create_object( QXmlStreamReader& Stream, Work* Root, Persistent::ID ObjectID ) const
  {
    ButtonBoxController* Result = 0;
    if( Stream.isStartElement() && Stream.name() == tag() && Root )
    {
      QXmlStreamAttributes Attr = Stream.attributes();
      ID ClientID = -1;
      if( attribute( Attr, "receiver", ClientID ) )
	if( Stopwatch* Receiver = Root->find_timer( ClientID ) )
	  Result = new ButtonBoxController( *Receiver, find_widget( Attr, "parent", Root ), ObjectID );
	else
	  Stream.raiseError( "Receiver for button box not found id:" + QString::number( ClientID ) );
      else
	Stream.raiseError( "No receiver attribute for button box." );
    }
    return Result;
  } // create_object( QXmlStreamReader&, Work* ) const
  const char ButtonBoxController::Loader::Tag[] = "button_box_controller";
  ButtonBoxController::ButtonBoxController( Client& Receiver0, QWidget* Parent, Persistent::ID ObjectID0 ) : WidgetController( Receiver0, Parent, ObjectID0 )
  {
    setObjectName( "Timeshop::ButtonBoxController-" + QString::number( id() ) );
  } // ButtonBoxController( Client&, QWidget*, Persistent::ID )
  void ButtonBoxController::prepare_layout()
  {
    QBoxLayout* Layout = new QBoxLayout( QBoxLayout::TopToBottom, this );
    Layout->setContentsMargins( 0, 0, 0, 0 );
    Layout->setSpacing( 2 );
    setLayout( Layout );
  } // prepare_layout()
  void ButtonBoxController::enable( CommandSet ToEnable, bool Enable )
  {
    Super::enable( ToEnable, Enable );
    CommandSet ToChange = ToEnable & ~Protected;
    foreach( ButtonsListEntry Entry, Buttons )
      if( ToChange.bit( Entry.first ) )
	Entry.second->setEnabled( Enable );
  } // enable( CommandSet, bool )
  void ButtonBoxController::swap( CommandSet ToHide, CommandSet ToShow )
  {
    QLayout* Layout = layout();
    bool LayoutEnabled = false;
    if( Layout )
    {
      LayoutEnabled = Layout->isEnabled();
      Layout->setEnabled( false );
    }
    Super::swap( ToHide, ToShow );
    if( Layout ) Layout->setEnabled( LayoutEnabled );
  } // swap( CommandSet, CommandSet )
  void ButtonBoxController::show( CommandSet ToShow, bool Show )
  {
    Controller::show( ToShow, Show );
    CommandSet ToChange = ToShow & ~Protected;
    foreach( ButtonsListEntry Entry, Buttons )
      if( ToChange.bit( Entry.first ) )
	Entry.second->setVisible( Show );
  } // show( CommandSet, bool )
  bool ButtonBoxController::add( QPushButton* Button, Command ForCommand, Qt::Alignment Align, int Stretch )
  {
    bool Result = true;
    Supported.set( ForCommand );
    const char* CommandName = 0;
    switch( ForCommand ) //! \todo  Maybe use array for slots?
    {
    case Commands::Start:
      CommandName = SLOT( start() );
      break;
    case Commands::Stop:
      CommandName = SLOT( stop() );
      break;
    case Commands::Clear:
      CommandName = SLOT( clear() );
      break;
    case Commands::Mark:
      CommandName = SLOT( mark() );
      break;
    case Commands::ClearMarks:
      CommandName = SLOT( clear_marks() );
      break;
    case Commands::Next:
      CommandName = SLOT( next() );
      break;
    default:
      Result = false;
    }
    if( CommandName )
    {
      if( Button->objectName().isEmpty() )
	Button->setObjectName( "ButtonBoxController_Button:" + QString( CommandName ) + "-" + QString::number( Buttons.size() ) );
      Buttons.push_back( ButtonsListEntry( ForCommand, Button ) );
      if( QLayout* Layout = layout() )
      {
	if( QBoxLayout* Box = qobject_cast<QBoxLayout*>( Layout ) )
	  Box->addWidget( Button, Stretch, Align );
	else
	  Layout->addWidget( Button );
      }
      connect( Button, SIGNAL( clicked() ), this, CommandName );
    }
    return Result;
  } // add( QPushButton*, Command, Qt::Alignment, int )
  bool ButtonBoxController::load_element( QXmlStreamReader& Stream, Work* Root )
  {
    QStringRef Tag = Stream.name();
    qDebug() << "\tButtonBoxControl: Field:" << Tag;
    if( Tag == "buttons" )
    {
      if( Root )
      {
	while( Loader::next_subelement( Stream ) )
	{
	  qDebug() << "\tButtonBoxControl: SubField:" << Stream.name();
	  if( Stream.name() == "box_command_button" )
	  {
	    QXmlStreamAttributes Attr = Stream.attributes();
	    int CommandID = 0;
	    if( Loader::attribute( Attr, "command", CommandID ) )
	    {
	      QPushButton* Button = new QPushButton( Loader::find_widget( Attr, "parent", Root ) );
	      QString ObjectName;
	      while( Loader::next_subelement( Stream ) )
		if( Stream.name() == "text" )
		  Button->setText( Stream.readElementText() );
		else if( Loader::load_widget_field( Stream, Button ) ) /* Nothing here */;
		else
		  Loader::skip( Stream );
	      add( Button, Command( CommandID ) );
	    }
	    else
	      Stream.raiseError( "ButtonBox command button without command." );
	  }
	}
      } // Root
      else
      {
	qDebug() << "Can't load box buttons without root.";
	Loader::skip( Stream );
      }
    }
    else if( Tag == "layout" )
    {
      if( QLayout* Layout = Loader::load_layout( Stream, *this ) )
	setLayout( Layout );
      else
	qDebug() << "ButtonBox layout load failed.";
    }
    else
      return Super::load_element( Stream, Root );
    return Stream.readNext() == QXmlStreamReader::EndElement;
  } // load_element( QXmlStreamReader&, Work* )
  void ButtonBoxController::write_elements( QXmlStreamWriter& Stream ) const
  {
    Super::write_elements( Stream );
    Stream.writeStartElement( "buttons" );
    foreach( ButtonsListEntry Button, Buttons )
    {
      QPushButton* ButtonPtr = Button.second;
      Stream.writeStartElement( "box_command_button" );
      Stream.writeAttribute( "command", QString::number( Button.first ) );
      if( QObject* ButtonParent = ButtonPtr->parent() )
	Stream.writeAttribute( "parent", ButtonParent->objectName() );
      Stream.writeTextElement( "text", ButtonPtr->text() );
      Loader::write_widget_fields( Stream, ButtonPtr );
      Stream.writeEndElement();
    }
    Stream.writeEndElement();
    Loader::write( Stream, layout() );
  } // write_elements( QXmlStreamWriter& ) const
} // Timeshop
