#ifndef TIMESHOP_MAIN_HPP
#define TIMESHOP_MAIN_HPP
#include <QSettings>
#include <timeshop.hpp>

class Timer : public Timeshop::AlarmTimerWidget
{
Q_OBJECT
public:
  typedef Timeshop::AlarmTimerWidget Super;
  class Loader : public Super::Loader
  {
  public:
    static const char Tag[];
    Loader( const char* Tag0 = Tag ) : Super::Loader( Tag0 ) {}
    Timeshop::Persistent* create_object( QXmlStreamReader& Stream, Timeshop::Work* Root, Timeshop::Persistent::ID ObjectID = -1 ) const
    {
      Timer* Result = 0;
      if( Root )
	if( Timeshop::TimerSettings* Settings = find_settings( Stream, Root ) )
	{
	  Result = new Timer( *Root, *Settings, 0, ObjectID );
	  Root->add_timer( *Result );
	}
      return Result;
    } // create_object( QXmlStreamReader&, Timeshop::Work*, Timeshop::Persistent::ID ) const
  }; // Loader
  //  static QString tr( const char* Text ) { return QApplication::translate( "Timer", Text ); }

  Timer( Timeshop::Work& Master0, Timeshop::TimerSettings& Settings0, QWidget* Parent = 0, Timeshop::Persistent::ID ObjectID = -1 );
  const char* loader_tag() const { return Loader::Tag; }
  void update_settings();
  void save_settings();
  void show_marks( bool Show = true );
  void show_presets( bool Show = true );
protected:
#if 0 //! \todo Read/write menu.
  bool load_element( QXmlStreamReader& Stream, Timeshop::Work* Root = 0 );
  void write_attributes( QXmlStreamWriter& Stream ) const;
  void write_elements( QXmlStreamWriter& Stream ) const;
#endif
  QAction* ShowMarksAction;
  QAction* ShowPresetsAction;
}; // Timer

class Work : public Timeshop::Work
{
Q_OBJECT
public:
  Work();
  ~Work();
  void load_from_config();
  void load_from_config( QSettings& Set );
  void save_to_stream();
}; // Work
#endif // TIMESHOP_MAIN_HPP
