# (c) Copyright 2009, 2010 Николай Слободской (Nick Slobodsky)
# This file is part of Timeshop.
#
# Timeshop is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Timeshop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
#
VERSION = 0.3.0

TEMPLATE = app
QT += phonon
TARGET = timeshop
QMAKE_CLEAN += $${TARGET}

unix {
isEmpty( PREFIX ) {
  PREFIX = /usr/local
}

BINDIR = $${PREFIX}/bin
DATADIR = $${PREFIX}/share

target.path += $${BINDIR}
INSTALLS += target

contains( QT_CONFIG, hildon ) {
ICONSUBDIR=hildon
}
else {
ICONSUBDIR=apps
}
# Icons install
ICONSIZES=16 32 48
ICONDIRPREFIX=$${DATADIR}/icons/hicolor

for( SIZE, ICONSIZES ) {
  ICON = icon$${SIZE}
  ICONPATH = $${ICONDIRPREFIX}/$${SIZE}x$${SIZE}/$${ICONSUBDIR}
  eval( $${ICON}.path = $${ICONPATH} )
  eval( $${ICON}.extra = $(INSTALL_FILE) images/timeshop/$${SIZE}.png $(INSTALL_ROOT)$${ICONPATH}/timeshop.png )
  eval( INSTALLS += $${ICON} )
}

# Menu item
contains( QT_CONFIG, hildon ) {
APPMENUSUBDIR = applications/hildon
# Desktop file translation
gettextfile.target = lang/ru.desktop.mo
gettextfile.depends = lang/ru.desktop.po
gettextfile.commands = msgfmt -o $${gettextfile.target} $${gettextfile.depends}
QMAKE_EXTRA_TARGETS += gettextfile
POST_TARGETDEPS += $${gettextfile.target}
QMAKE_CLEAN += $${gettextfile.target}
gettextfile.path = $${DATADIR}/locale/ru/LC_MESSAGES
gettextfile.extra = $(INSTALL_FILE) $${gettextfile.target} $(INSTALL_ROOT)$${gettextfile.path}/$${TARGET}.desktop.mo
INSTALLS += gettextfile
}
else {
  APPMENUSUBDIR = applications
}
appmenu.target = $${TARGET}.desktop
appmenu.depends = $${appmenu.target}.in
#appmenu.commands = echo $${appmenu.target}
appmenu.commands = sed s\|@BINDIR@\|$${BINDIR}\| < $${appmenu.depends} > $${appmenu.target}
QMAKE_EXTRA_TARGETS += appmenu
POST_TARGETDEPS += $${appmenu.target}
QMAKE_CLEAN += $${appmenu.target}
appmenu.path = $${DATADIR}/$${APPMENUSUBDIR}
appmenu.extra = $(INSTALL_FILE) timeshop.desktop $(INSTALL_ROOT)$${appmenu.path}/$${TARGET}.desktop
INSTALLS += appmenu
} # unix

DEPENDPATH += ../lib
INCLUDEPATH += ../lib
unix {
  QMAKE_LIBDIR_FLAGS += -L../lib
  LIBS += -ltimeshop
}

# Input
SOURCES += timeshop_main.cpp
HEADERS += timeshop_main.hpp
win32 {
  RC_FILE = w32/timeshop.rc
}
#! \todo Move translation to separate langpack.
trans.target = lang/app-ru.qm
trans.depends = lang/app-ru.ts
trans.commands = lrelease app.pro
QMAKE_EXTRA_TARGETS += trans
QMAKE_CLEAN += $${trans.target}
PRE_TARGETDEPS += $${trans.target}
TRANSLATIONS = $${trans.depends}

RESOURCES = timeshop_app.qrc
