// -*- coding: utf-8; -*-
// (c) Copyright 2009, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//

#include <QApplication>
#include <QSettings>
#include <QDebug>
#include <QTranslator>
#include <QMenuBar>
#include <timeshop.hpp>

class Timer : public Timeshop::AlarmTimer
{
public:
  Timer( Timeshop::TimerSettings& Settings0, QWidget* Parent = 0 ) : AlarmTimer( Settings0, Parent ) {}
  void update_settings();
}; // Timer
void Timer::update_settings()
{
  AlarmTimer::update_settings();
  QSettings().setValue( "Timer/InitTime", settings().init_time() );
  QSettings().setValue( "Timer/Precision", settings().precision() );
  QSettings().setValue( "Timer/AlarmSound", settings().alarm_sound() );
} // update_settings()
  
int main( int argc, char* argv[] )
{
  QApplication App( argc, argv );
  App.setOrganizationName( "Nick Slobodsky" );
  App.setApplicationName( "Timeshop" );
  if( QSettings().contains( "Qt/Style" ) )
    QApplication::setStyle( QSettings().value( "Qt/Style" ).toString() );
  QTranslator Trans;
  if( Trans.load( ":/lang/ru.qm" ) )
    App.installTranslator( &Trans );
  else
    qDebug() << "Can\'t load translator.";
  QIcon Icon( ":/images/timeshop/16.png" );
  Icon.addFile( ":/images/timeshop/32.png" );
  Icon.addFile( ":/images/timeshop/48.png" );
  Timeshop::TimerSettings Settings( QSettings().value( "Timer/InitTime" ).toLongLong() );
  Settings.precision( QSettings().value( "Timer/Precision" ).toInt() );
  Settings.alarm_sound( QSettings().value( "Timer/AlarmSound" ).toString() );
  Timer* Window = new Timer( Settings );
  Window->setWindowIcon( Icon );
  Window->setContextMenuPolicy( Qt::ActionsContextMenu );
  QAction* Act = new Timeshop::SettingsAction( Settings, QObject::tr( "Settings..." ), Window );
  Window->connect( Act, SIGNAL( settings_changed() ), SLOT( update_settings() ) );
  Window->addAction( Act );
#ifndef Q_WS_HILDON
  Timeshop::StylesMenu* Styles = new Timeshop::StylesMenu( QObject::tr( "Style" ) );
  Window->addAction( Styles->menuAction() );
#endif
  Window->addAction( new Timeshop::AboutAction( QObject::tr( "Time Workshop (Timeshop). Version 0.2.1"
							     "\n\xA9 Copyright 2009,2010 Nick Slobodsky (" ) + QString::fromUtf8( "Николай Слободской" ) +
						QObject::tr( ")\nHomepage: http://timeshop.garage.maemo.org"
							     "\n\nThis is a stopwatch and alarm timer utility with user defined precision and alarm sound. More features will be available soon." ),
						QObject::tr( "About Time Workshop" ), Window ) );
  Act = new QAction( Window );
  Act->setSeparator( true );
  Window->addAction( Act );
  Act = new QAction( QObject::tr( "Exit" ), Window );
  if( Window->connect( Act, SIGNAL( triggered( bool ) ), SLOT( close() ) ) )
    Window->addAction( Act );
#if defined( WINCE ) || defined( Q_WS_HILDON )
  QMenuBar* Menu = new QMenuBar( Window );
  foreach( QAction* Action, Window->actions() )
    Menu->addAction( Action );
#endif
  Window->show();
  return App.exec();
} // ( int, char* )
