/*
 * This file is part of TimedSilencer.
 *
 *  TimedSilencer is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TimedSilencer is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TimedSilencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QIcon>
#include <QPainter>
#include "eventlistdelegate.h"
#include "switchingeventlist.h"

EventListDelegate::EventListDelegate()
{
}

void EventListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
  QStyleOptionViewItem opt = option;
  opt.displayAlignment = Qt::AlignCenter;
  QStyledItemDelegate::paint(painter, opt, index);
  if(index.column() == EV_STATUS) {
    // Draw checkbox
    QIcon::fromTheme("general_tickmark_checked");
    // Is selected
    // Draw checkbox
    QIcon cbIco;
    if(index.data(Qt::UserRole).toBool()) {
      cbIco = QIcon::fromTheme("clock_alarm_on");
    } else {
      cbIco = QIcon::fromTheme("clock_alarm_off");
    }
    QPixmap cbPix = cbIco.pixmap(cbIco.actualSize(option.decorationSize));
    QRect cbRect = option.rect;
    cbRect.setWidth(cbPix.width());
    cbRect.setHeight(cbPix.height());
    cbRect.moveCenter(option.rect.center());;
    painter->drawPixmap(cbRect, cbPix);
  }
}
