/*
 * This file is part of TimedSilencer.
 *
 *  TimedSilencer is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TimedSilencer is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TimedSilencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QPainter>
#include <QItemDelegate>
#include "checklistdelegate.h"

CheckListDelegate::CheckListDelegate()
{

}

void CheckListDelegate::paint(QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const {
  // Save painter
  painter->save();

  QStyleOptionViewItem opt = option;
  opt.displayAlignment = Qt::AlignCenter;
  QStyledItemDelegate::paint(painter, opt, index);

  if (option.state & QStyle::State_Selected) {
    // Is selected
    // Draw checkbox
    QIcon cbIco = QIcon::fromTheme("widgets_tickmark_list");
    QPixmap cbPix = cbIco.pixmap(cbIco.actualSize(option.decorationSize));
    //qDebug("Pix size: (%d, %d)", cbPix.width(), cbPix.height());
    QRect cbRect = option.rect;
    cbRect.setLeft(cbRect.left()+(cbRect.width()-cbPix.width()));
    int diff_height = cbRect.height() - cbPix.height();
    cbRect.setHeight(cbPix.height());
    cbRect.moveBottom(cbRect.bottom()+(diff_height/2.));
    //qDebug("Rect size: (%d, %d)", cbRect.width(), cbRect.height());
    painter->drawPixmap(cbRect, cbPix);
  }

  // Restore painter
  painter->restore();
}
