/*
** Copyright (c) 2009  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

//-----------------------------------------------------------------------------
/* TODO
** - Settings dialog: Alarm file (choose from ringtones + "More" to choose any file)
** - "Restart" button for the count down
*/
//-----------------------------------------------------------------------------

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "custombutton.h"
#include "debugtext.h"
#include "view.h"
#include "timegroup.h"
#include "textitem.h"

enum eColor
{
    Color_Window_Background,
    Color_Help_Text,
    Color_Last
};

enum ePixmap
{
    Pixmap_Numbers,
    Pixmap_Dimmed_Numbers,
    Pixmap_Flipped_Numbers,
    Pixmap_Last
};

class CMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    CMainWindow(QWidget* pParent = 0);
    ~CMainWindow();

    void intialize();
    void stopUpdates(bool bStop);

    static const QColor& getColor(eColor color) { return c_Colors[color]; }
    static const QPixmap* getPixmap(ePixmap pixmap) { return c_Pixmaps[pixmap]; }

public slots:
    void onReset();
    void onRestart();
    void onStart();
    void onTimeout();
    void onAbout();
    void onShowClock();
    void onNightMode();
    void onPresets();
    void onPresetsChanged();

protected:
    virtual void resizeEvent(QResizeEvent* pEvent);

private:
    void updateValue(int newValue);
    void enableEditMode(bool bEnable);
    void turnBacklightOn();
    void initGraphics(bool bInvert);

    QGraphicsScene* m_pScene;        ///< Pointer to the scene
    CView* m_pView;                  ///< Pointer to the view

    CTimeGroup* m_pTimeGroup;        ///< The main time group

    CCustomButton* m_pButtonStart;   ///< Start/Pause/Resume button
    CCustomButton* m_pButtonReset;   ///< Reset button
    CTextItem* m_pHelpText;          ///< Help text

    QPixmap m_pxPause;               ///< The icon for the pause button
    QPixmap m_pxStart;               ///< The icon for the start button

    QAction* m_KeepBacklightAction;  ///< Action to keep the backlight always on
    QAction* m_ShowClockAction;      ///< Action to toggle current time/timer
    QAction* m_NightModeAction;      ///< Action to toggle night mode
    QAction* m_PresetsAction;        ///< Action to show presets
    bool m_bShowTime;                ///< True when time is shown, False when timer

    QTimer m_Timer;                  ///< Timer for the count down/up
    bool m_bCountDown;               ///< True if timer counts down
    int m_StartTime;                 ///< The time countdown started from

    QString m_strAlarm;              ///< Sound or file to be executed when counter goes to 0

    QList<int> m_Presets;            ///< List of preset values

    static QColor c_Colors[Color_Last];     ///< The array of common colors
    static QPixmap* c_Pixmaps[Pixmap_Last];  ///< The array of common pixmaps

#ifdef Q_WS_MAEMO_5
    osso_context_t* m_pOssoContext;  ///< The OSSO context for backlight
#endif
};

#endif // MAINWINDOW_H
