/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#include "aboutdialog.h"

//-----------------------------------------------------------------------------
/**
** Constructor
**
** \param pParent The parent for the main window (usually NULL)
*/
CAboutDialog::CAboutDialog(QWidget* pParent) : QDialog(pParent)
{
    ui.setupUi(this);

    QSettings settings;
    ui.lineEdit->setText(settings.value("Alarm").toString());

    bool bOk = connect(ui.toolButton, SIGNAL(clicked()), this, SLOT(onBrowse()));
    Q_ASSERT(bOk);
}

//-----------------------------------------------------------------------------
/**
** Destructor
*/
CAboutDialog::~CAboutDialog()
{
}

//-----------------------------------------------------------------------------
/**
** Slot which gets called when the browse button is clicked. Opens a file dialog
** for the user to choose the alarm sound/file. The selected file will be written
** to settings.
*/
void CAboutDialog::onBrowse()
{
    QString strFileName = QFileDialog::getOpenFileName(this, tr("Choose audio file or executable"));
    if (!strFileName.isEmpty())
    {
        QSettings settings;
        settings.setValue("Alarm", strFileName);

        ui.lineEdit->setText(strFileName);
   }
}

// EOF
