/*
** Copyright (c) 2009  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#include "precompiled.h"
#include "textitem.h"

//-----------------------------------------------------------------------------
/**
** The constructor.
*/
CTextItem::CTextItem() : QGraphicsItem()
{
}

//-----------------------------------------------------------------------------
/**
** The destructor.
*/
CTextItem::~CTextItem()
{
}

//-----------------------------------------------------------------------------
/**
** Sets a new value for the text.
*/
void CTextItem::setText(QString strText)
{ 
    m_Text = strText;
    update(); 
}

//-----------------------------------------------------------------------------
/**
** Returns the bounding rectangle of the item.
**
** \return The bounding rectangle.
*/
QRectF CTextItem::boundingRect() const
{
    QFont font;
    font.setPixelSize(20);

    QFontMetrics metrics(font);
    QRectF r = metrics.boundingRect(m_Text);
    return QRectF(0, 0, r.width(), r.height());
}

//-----------------------------------------------------------------------------
/**
** Paints the text to the widget.
**
** \param pPainter Pointer to the painter object.
** \param pOption The paint options.
** \param pWidget The target widget.
**
*/
void CTextItem::paint(QPainter* pPainter, const QStyleOptionGraphicsItem* pOption, QWidget* pWidget)
{
    Q_UNUSED(pOption);
    Q_UNUSED(pWidget);

    QFont font;
    font.setPixelSize(20);
    pPainter->setFont(font);

    QRectF r = boundingRect();
    pPainter->setPen(m_Color);
    pPainter->drawText(r, m_Text);
}

// EOF
