#include <concurrency/ThreadManager.h>
#include <concurrency/PosixThreadFactory.h>
#include <protocol/TBinaryProtocol.h>
#include <server/TSimpleServer.h>
#include <server/TThreadPoolServer.h>
#include <server/TThreadedServer.h>
#include <transport/TSSLServerSocket.h>
#include <transport/TTransportUtils.h>
#include <transport/TSSLContext.h>

#include <iostream>
#include <stdexcept>
#include <sstream>
#include <signal.h>

#include "../gen-cpp/Calculator.h"

using namespace std;
using namespace facebook::thrift;
using namespace facebook::thrift::protocol;
using namespace facebook::thrift::transport;
using namespace facebook::thrift::concurrency;
using namespace facebook::thrift::server;

using namespace tutorial;
using namespace shared;

using namespace boost;

class CalculatorHandler : public CalculatorIf {
 public:
  CalculatorHandler() {}

  void ping() {
    printf("ping()\n");
  }

  int32_t add(const int32_t n1, const int32_t n2) {
    printf("add(%d,%d)\n", n1, n2);
    return n1 + n2;
  }

  int32_t calculate(const int32_t logid, const Work &work) {
    printf("calculate(%d,{%d,%d,%d})\n", logid, work.op, work.num1, work.num2);
    int32_t val;

    switch (work.op) {
    case ADD:
      val = work.num1 + work.num2;
      break;
    case SUBTRACT:
      val = work.num1 - work.num2;
      break;
    case MULTIPLY:
      val = work.num1 * work.num2;
      break;
    case DIVIDE:
      if (work.num2 == 0) {
        InvalidOperation io;
        io.what = work.op;
        io.why = "Cannot divide by 0";
        throw io;
      }
      val = work.num1 / work.num2;
      break;
    default:
      InvalidOperation io;
      io.what = work.op;
      io.why = "Invalid Operation";
      throw io;
    }

    SharedStruct ss;
    ss.key = logid;
    char buffer[11];
    sprintf(buffer, "%d", val);
    ss.value = buffer;

    log[logid] = ss;

    return val;
  }

  void getStruct(SharedStruct &ret, const int32_t logid) {
    printf("getStruct(%d)\n", logid);
    ret = log[logid];
  }

  void zip() {
    printf("zip()\n");
  }

protected:
  map<int32_t, SharedStruct> log;

};

string keyfile;
string certfile;
string ringfile;
int workerCount = 10;
shared_ptr<TServer>gp_server;
shared_ptr<TSSLContext>gp_context;

void terminate (int param)
{
  printf ("Terminating program...\n");
  gp_server->stop();
  gp_context.reset();
  exit(1);
}

int main(int argc, char **argv) {

  if (argc < 3){
    cout << "Usage: SSLCppServer public_key.pem private_key.pem" << endl;
    exit(-1);
  }
  std::string pubKeyFile = argv[1];
  std::string privKeyFile = argv[2];

  void (*prev_fn)(int);
  prev_fn = signal (SIGINT,terminate);

  shared_ptr<TProtocolFactory> protocolFactory(new TBinaryProtocolFactory());
  shared_ptr<CalculatorHandler> handler(new CalculatorHandler());
  shared_ptr<TProcessor> processor(new CalculatorProcessor(handler));
  shared_ptr<TSSLServerSocket> serverTransport(new 
					       TSSLServerSocket(9090,
								pubKeyFile,
								privKeyFile));
  shared_ptr<TSSLContext> tctx(new TSSLContext());
  serverTransport->setTCTX(tctx);
  serverTransport->setParaniodCheckState(false);
  shared_ptr<TTransportFactory> transportFactory(new TBufferedTransportFactory());

  shared_ptr<TServer> srv(new TSimpleServer (processor,
					     serverTransport,
					     transportFactory,
					     protocolFactory));
  gp_server.swap(srv);
  gp_context.swap(tctx);

  /**
   * Or you could do one of these
   */
  /*
  shared_ptr<ThreadManager> threadManager =
    ThreadManager::newSimpleThreadManager(workerCount);
  shared_ptr<PosixThreadFactory> threadFactory =
    shared_ptr<PosixThreadFactory>(new PosixThreadFactory());
  threadManager->threadFactory(threadFactory);
  threadManager->start();
  TThreadPoolServer server(processor,
                           serverTransport,
                           transportFactory,
                           protocolFactory,
                           threadManager);
  */
  /*
  TThreadedServer server(processor,
                         serverTransport,
                         transportFactory,
                         protocolFactory);

  */

  printf("Starting the server...\n");
  gp_server->serve();
  printf("done.\n");

  tctx.reset();

  return 0;
}
