// Distributed under the Thrift Software License
//
// See accompanying file LICENSE or visit the Thrift site at:
// http://developers.apache.com/thrift/
//

#ifndef _THRIFT_TRANSPORT_TSECURETRANSPORT_H_
#define _THRIFT_TRANSPORT_TSECURETRANSPORT_H_ 1

/* OpenSSL headers */
#include <openssl/bio.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>

#include "TServerTransport.h"
#include "TTransport.h"

namespace apache { namespace thrift { namespace transport {

/**
 * Class containing functions shared between the server and client 
 * implementations of a SSL based socket.
 *
 * @author Ian Pye <ianpye@gmail.com>
*/
      
class TSSLTransport {
 public:

  TSSLTransport();
  ~TSSLTransport();

  bool basicVerify(SSL *, const std::string&);

   /**
   * Do any extra checks which might be desired. 
   * Currently, checks the certs. hostname against the 
   * hostname we are connected to.
   * 
   * Returns true if everything is OK, false otherwise.
   */
  bool extendedVerify(X509 *, const std::string &);
  /** 
   * Set extra cert. checking
   */
  void setParaniodCheckState(bool state){
    paranoid_ = state;
  }

 private:
  bool paranoid_;

};
      
}}} // apache::thrift::transport

#endif // #ifndef _THRIFT_TRANSPORT_TSECURETRANSPORT_H_
