// Distributed under the Thrift Software License
//
// See accompanying file LICENSE or visit the Thrift site at:
// http://developers.apache.com/thrift/

#ifndef _THRIFT_TRANSPORT_TSSLCONTEXT_H_
#define _THRIFT_TRANSPORT_TSSLCONTEXT_H_ 1

#include <string>
#include <sys/time.h>

/* OpenSSL headers */
#include <openssl/bio.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>

#include "TTransport.h"

namespace apache { namespace thrift { namespace transport {

/**
 * OpenSSL implementation of the TTransport interface.
 * This class is a wrapper for a OpenSSL context.
 *
 * @author Ian Pye <ianpye@gmail.com>
 */

// Return values from the seedPRNG function.
static const int TIMES_TO_TRY_ADDING_RAND = 10;
static const int SEED_FAILED = -100;
static const int SEED_WITH_EGD = 100;
static const int SEED_WITH_URANDOM = 200;

class TSSLContext {

 public:
  TSSLContext();
  virtual ~TSSLContext();
  void loadTrustStore(std::string&);
  void loadCertChainFile(std::string&);
  void loadPrivateKey(std::string&);
  void setEGD(const std::string &egd){ 
    egd_ = egd;
    useEGD_ = true;
  }
  virtual int addRand(void *);
  void set_userInfo(void *ui){
    SSL_CTX_set_default_passwd_cb_userdata(ctx_, ui);
  }
  void set_passwd_cb(pem_password_cb *cb){
    SSL_CTX_set_default_passwd_cb(ctx_, cb);
  }
  virtual SSL_CTX *getSSLCTX();

 protected:
  virtual int seedRand();
  SSL_CTX *ctx_;
  bool useEGD_;
  std::string egd_;

};
}}} // apache::thrift::transport

#endif // #ifndef _THRIFT_TRANSPORT_TSSLCONTEXT_H_
