/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class DefaultModuleDescriptor
implements ModuleDescriptor {
    private ModuleRevisionId revId;
    private ModuleRevisionId resolvedRevId;
    private String status = StatusManager.getCurrent().getDefaultStatus();
    private Date publicationDate;
    private Date resolvedPublicationDate;
    private List dependencies = new ArrayList();
    private Map configurations = new LinkedHashMap();
    private Map artifactsByConf = new HashMap();
    private Collection artifacts = new LinkedHashSet();
    private boolean isDefault = false;
    private ModuleRules conflictManagers = new ModuleRules();
    private ModuleRules dependencyDescriptorMediators = new ModuleRules();
    private List licenses = new ArrayList();
    private String homePage;
    private String description = "";
    private long lastModified = 0L;
    private Namespace namespace;
    private boolean mappingOverride;
    private ModuleDescriptorParser parser;
    private Resource resource;
    private List excludeRules = new ArrayList();
    private Artifact metadataArtifact;
    private Map extraAttributesNamespaces = new LinkedHashMap();
    private Map extraInfo = new HashMap();

    public static DefaultModuleDescriptor newDefaultInstance(ModuleRevisionId mrid) {
        return DefaultModuleDescriptor.newDefaultInstance(mrid, null);
    }

    public static DefaultModuleDescriptor newCallerInstance(ModuleRevisionId mrid, String[] confs, boolean transitive, boolean changing) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(ModuleRevisionId.newInstance(mrid.getOrganisation(), mrid.getName() + "-caller", "working"), "integration", null, true);
        for (int i = 0; i < confs.length; ++i) {
            moduleDescriptor.addConfiguration(new Configuration(confs[i]));
        }
        moduleDescriptor.setLastModified(System.currentTimeMillis());
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(moduleDescriptor, mrid, true, changing, transitive);
        for (int j = 0; j < confs.length; ++j) {
            dd.addDependencyConfiguration(confs[j], confs[j]);
        }
        moduleDescriptor.addDependency(dd);
        return moduleDescriptor;
    }

    public static DefaultModuleDescriptor newCallerInstance(ModuleRevisionId[] mrid, boolean transitive, boolean changing) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(ModuleRevisionId.newInstance("caller", "all-caller", "working"), "integration", null, true);
        moduleDescriptor.addConfiguration(new Configuration("default"));
        moduleDescriptor.setLastModified(System.currentTimeMillis());
        for (int i = 0; i < mrid.length; ++i) {
            DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(moduleDescriptor, mrid[i], true, changing, transitive);
            dd.addDependencyConfiguration("default", "*");
            moduleDescriptor.addDependency(dd);
        }
        return moduleDescriptor;
    }

    public static DefaultModuleDescriptor newDefaultInstance(ModuleRevisionId mrid, DependencyArtifactDescriptor[] artifacts) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(mrid, "release", null, true);
        moduleDescriptor.addConfiguration(new Configuration("default"));
        if (artifacts != null && artifacts.length > 0) {
            for (int i = 0; i < artifacts.length; ++i) {
                moduleDescriptor.addArtifact("default", new MDArtifact(moduleDescriptor, artifacts[i].getName(), artifacts[i].getType(), artifacts[i].getExt(), artifacts[i].getUrl(), null));
            }
        } else {
            moduleDescriptor.addArtifact("default", new MDArtifact(moduleDescriptor, mrid.getName(), "jar", "jar"));
        }
        moduleDescriptor.setLastModified(System.currentTimeMillis());
        return moduleDescriptor;
    }

    public static DefaultModuleDescriptor newBasicInstance(ModuleRevisionId mrid, Date publicationDate) {
        DefaultModuleDescriptor moduleDescriptor = new DefaultModuleDescriptor(mrid, "release", publicationDate, false);
        moduleDescriptor.addConfiguration(new Configuration("default"));
        moduleDescriptor.addArtifact("default", new MDArtifact(moduleDescriptor, mrid.getName(), "jar", "jar"));
        return moduleDescriptor;
    }

    public static ModuleDescriptor transformInstance(ModuleDescriptor md, Namespace ns) {
        NamespaceTransformer t = ns.getToSystemTransformer();
        if (t.isIdentity()) {
            return md;
        }
        DefaultModuleDescriptor nmd = new DefaultModuleDescriptor(md.getParser(), md.getResource());
        nmd.revId = t.transform(md.getModuleRevisionId());
        nmd.resolvedRevId = t.transform(md.getResolvedModuleRevisionId());
        nmd.status = md.getStatus();
        nmd.publicationDate = md.getPublicationDate();
        nmd.resolvedPublicationDate = md.getResolvedPublicationDate();
        DependencyDescriptor[] dd = md.getDependencies();
        for (int i = 0; i < dd.length; ++i) {
            nmd.dependencies.add(NameSpaceHelper.toSystem(dd[i], ns));
        }
        Configuration[] confs = md.getConfigurations();
        for (int i = 0; i < confs.length; ++i) {
            nmd.configurations.put(confs[i].getName(), confs[i]);
            Artifact[] arts = md.getArtifacts(confs[i].getName());
            for (int j = 0; j < arts.length; ++j) {
                nmd.addArtifact(confs[i].getName(), NameSpaceHelper.transform(arts[j], t));
            }
        }
        nmd.setDefault(md.isDefault());
        if (md instanceof DefaultModuleDescriptor) {
            DefaultModuleDescriptor dmd = (DefaultModuleDescriptor)md;
            nmd.conflictManagers = (ModuleRules)dmd.conflictManagers.clone();
            nmd.dependencyDescriptorMediators = (ModuleRules)dmd.dependencyDescriptorMediators.clone();
        } else {
            Message.warn("transformed module descriptor is not a default module descriptor: impossible to copy conflict manager and version mediation configuration: " + md);
        }
        nmd.licenses.addAll(Arrays.asList(md.getLicenses()));
        nmd.homePage = md.getHomePage();
        nmd.description = md.getDescription();
        nmd.lastModified = md.getLastModified();
        nmd.extraAttributesNamespaces = md.getExtraAttributesNamespaces();
        nmd.extraInfo = md.getExtraInfo();
        nmd.namespace = ns;
        return nmd;
    }

    public DefaultModuleDescriptor(ModuleRevisionId id, String status, Date pubDate) {
        this(id, status, pubDate, false);
    }

    public DefaultModuleDescriptor(ModuleRevisionId id, String status, Date pubDate, boolean isDefault) {
        if (id == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        if (status == null) {
            throw new NullPointerException("null status not allowed");
        }
        this.revId = id;
        this.resolvedRevId = id;
        this.status = status;
        this.publicationDate = pubDate;
        this.resolvedPublicationDate = this.publicationDate == null ? new Date() : this.publicationDate;
        this.isDefault = isDefault;
        this.parser = XmlModuleDescriptorParser.getInstance();
    }

    public DefaultModuleDescriptor(ModuleDescriptorParser parser, Resource res) {
        this.parser = parser;
        this.resource = res;
    }

    public Artifact getMetadataArtifact() {
        if (this.metadataArtifact == null) {
            this.metadataArtifact = DefaultArtifact.newIvyArtifact(this.resolvedRevId, this.resolvedPublicationDate);
        }
        return this.metadataArtifact;
    }

    public void setModuleArtifact(Artifact moduleArtifact) {
        this.metadataArtifact = moduleArtifact;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setPublicationDate(Date publicationDate) {
        this.publicationDate = publicationDate;
        if (this.resolvedPublicationDate == null) {
            this.resolvedPublicationDate = publicationDate == null ? new Date() : publicationDate;
        }
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public void setResolvedPublicationDate(Date publicationDate) {
        if (publicationDate == null) {
            throw new NullPointerException("null publication date not allowed");
        }
        this.resolvedPublicationDate = publicationDate;
    }

    public Date getResolvedPublicationDate() {
        return this.resolvedPublicationDate;
    }

    public String getRevision() {
        return this.getResolvedModuleRevisionId().getRevision();
    }

    public void setModuleRevisionId(ModuleRevisionId revId) {
        if (revId == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        this.revId = revId;
        if (this.resolvedRevId == null) {
            this.resolvedRevId = revId;
        }
    }

    public void setResolvedModuleRevisionId(ModuleRevisionId revId) {
        this.resolvedRevId = revId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void addDependency(DependencyDescriptor dependency) {
        this.dependencies.add(dependency);
    }

    public void addConfiguration(Configuration conf) {
        this.configurations.put(conf.getName(), conf);
    }

    public void addArtifact(String conf, Artifact artifact) {
        if (!this.configurations.containsKey(conf)) {
            throw new IllegalArgumentException("Configuration '" + conf + "' doesn't exist in module " + this);
        }
        ArrayList<Artifact> artifacts = (ArrayList<Artifact>)this.artifactsByConf.get(conf);
        if (artifacts == null) {
            artifacts = new ArrayList<Artifact>();
            this.artifactsByConf.put(conf, artifacts);
        }
        artifacts.add(artifact);
        this.artifacts.add(artifact);
    }

    public ModuleRevisionId getModuleRevisionId() {
        return this.revId;
    }

    public ModuleRevisionId getResolvedModuleRevisionId() {
        return this.resolvedRevId;
    }

    public String getStatus() {
        return this.status;
    }

    public Configuration[] getConfigurations() {
        return this.configurations.values().toArray(new Configuration[this.configurations.size()]);
    }

    public String[] getConfigurationsNames() {
        return this.configurations.keySet().toArray(new String[this.configurations.size()]);
    }

    public String[] getPublicConfigurationsNames() {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator iter = this.configurations.values().iterator();
        while (iter.hasNext()) {
            Configuration conf = (Configuration)iter.next();
            if (conf.getVisibility() != Configuration.Visibility.PUBLIC) continue;
            ret.add(conf.getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Configuration getConfiguration(String confName) {
        return (Configuration)this.configurations.get(confName);
    }

    public Artifact[] getArtifacts(String conf) {
        Collection artifacts = (Collection)this.artifactsByConf.get(conf);
        if (artifacts == null) {
            return new Artifact[0];
        }
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    public Artifact[] getAllArtifacts() {
        return this.artifacts.toArray(new Artifact[this.artifacts.size()]);
    }

    public DependencyDescriptor[] getDependencies() {
        return this.dependencies.toArray(new DependencyDescriptor[this.dependencies.size()]);
    }

    public boolean dependsOn(VersionMatcher matcher, ModuleDescriptor md) {
        Iterator iter = this.dependencies.iterator();
        while (iter.hasNext()) {
            DependencyDescriptor dd = (DependencyDescriptor)iter.next();
            if (!dd.getDependencyId().equals(md.getModuleRevisionId().getModuleId())) continue;
            if (md.getResolvedModuleRevisionId().getRevision() == null) {
                return true;
            }
            if (!matcher.accept(dd.getDependencyRevisionId(), md)) continue;
            return true;
        }
        return false;
    }

    public void toIvyFile(File destFile) throws ParseException, IOException {
        if (this.parser != null && this.resource != null) {
            this.parser.toIvyFile(this.resource.openStream(), this.resource, destFile, this);
        } else {
            XmlModuleDescriptorWriter.write(this, destFile);
        }
    }

    public String toString() {
        return "module: " + this.revId + " status=" + this.status + " publication=" + this.publicationDate + " configurations=" + this.configurations + " artifacts=" + this.artifactsByConf + " dependencies=" + this.dependencies;
    }

    public void setDefault(boolean b) {
        this.isDefault = b;
    }

    public void addConflictManager(ModuleId moduleId, PatternMatcher matcher, ConflictManager manager) {
        this.conflictManagers.defineRule(new MapMatcher(moduleId.getAttributes(), matcher), manager);
    }

    public ConflictManager getConflictManager(ModuleId moduleId) {
        return (ConflictManager)this.conflictManagers.getRule(moduleId);
    }

    public void addDependencyDescriptorMediator(ModuleId moduleId, PatternMatcher matcher, DependencyDescriptorMediator ddm) {
        this.dependencyDescriptorMediators.defineRule(new MapMatcher(moduleId.getAttributes(), matcher), ddm);
    }

    public DependencyDescriptor mediate(DependencyDescriptor dd) {
        Object[] mediators = this.dependencyDescriptorMediators.getRules(dd.getDependencyId());
        for (int i = 0; i < mediators.length; ++i) {
            dd = ((DependencyDescriptorMediator)mediators[i]).mediate(dd);
        }
        return dd;
    }

    public ModuleRules getAllDependencyDescriptorMediators() {
        return (ModuleRules)this.dependencyDescriptorMediators.clone();
    }

    public void addLicense(License license) {
        this.licenses.add(license);
    }

    public License[] getLicenses() {
        return this.licenses.toArray(new License[this.licenses.size()]);
    }

    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public boolean isNamespaceUseful() {
        Iterator iter = this.dependencies.iterator();
        while (iter.hasNext()) {
            DependencyDescriptor dd = (DependencyDescriptor)iter.next();
            if (dd.getAllExcludeRules().length <= 0) continue;
            return true;
        }
        return false;
    }

    public void setNamespace(Namespace ns) {
        this.namespace = ns;
    }

    public void check() {
        Stack<String> confs = new Stack<String>();
        Iterator iter = this.configurations.values().iterator();
        while (iter.hasNext()) {
            Configuration conf = (Configuration)iter.next();
            String[] ext = conf.getExtends();
            for (int i = 0; i < ext.length; ++i) {
                confs.push(conf.getName());
                this.checkConf(confs, ext[i].trim());
                confs.pop();
            }
        }
    }

    private void checkConf(Stack confs, String confName) {
        int index = confs.indexOf(confName);
        if (index != -1) {
            StringBuffer cycle = new StringBuffer();
            while (index < confs.size()) {
                cycle.append(confs.get(index)).append(" => ");
                ++index;
            }
            cycle.append(confName);
            throw new IllegalStateException("illegal cycle detected in configuration extension: " + cycle);
        }
        Configuration conf = this.getConfiguration(confName);
        if (conf == null) {
            throw new IllegalStateException("unknown configuration '" + confName + "'. It is extended by " + confs.get(confs.size() - 1));
        }
        String[] ext = conf.getExtends();
        for (int i = 0; i < ext.length; ++i) {
            confs.push(conf.getName());
            this.checkConf(confs, ext[i].trim());
            confs.pop();
        }
    }

    public void setMappingOverride(boolean override) {
        this.mappingOverride = override;
    }

    public boolean isMappingOverride() {
        return this.mappingOverride;
    }

    public String getAttribute(String attName) {
        return this.resolvedRevId.getAttribute(attName);
    }

    public Map getAttributes() {
        return this.resolvedRevId.getAttributes();
    }

    public String getExtraAttribute(String attName) {
        return this.resolvedRevId.getExtraAttribute(attName);
    }

    public Map getExtraAttributes() {
        return this.resolvedRevId.getExtraAttributes();
    }

    public Map getQualifiedExtraAttributes() {
        return this.resolvedRevId.getQualifiedExtraAttributes();
    }

    public ModuleDescriptorParser getParser() {
        return this.parser;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void addExcludeRule(ExcludeRule rule) {
        this.excludeRules.add(rule);
    }

    public boolean canExclude() {
        return !this.excludeRules.isEmpty();
    }

    public boolean doesExclude(String[] moduleConfigurations, ArtifactId artifactId) {
        if (this.namespace != null) {
            artifactId = NameSpaceHelper.transform(artifactId, this.namespace.getFromSystemTransformer());
        }
        ExcludeRule[] rules = this.getExcludeRules(moduleConfigurations);
        for (int i = 0; i < rules.length; ++i) {
            if (!MatcherHelper.matches(rules[i].getMatcher(), rules[i].getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    public ExcludeRule[] getAllExcludeRules() {
        return this.excludeRules.toArray(new ExcludeRule[this.excludeRules.size()]);
    }

    public ExcludeRule[] getExcludeRules(String[] moduleConfigurations) {
        LinkedHashSet<ExcludeRule> rules = new LinkedHashSet<ExcludeRule>();
        Iterator iter = this.excludeRules.iterator();
        while (iter.hasNext()) {
            ExcludeRule rule = (ExcludeRule)iter.next();
            String[] ruleConfs = rule.getConfigurations();
            if (!this.containsAny(ruleConfs, moduleConfigurations)) continue;
            rules.add(rule);
        }
        return rules.toArray(new ExcludeRule[rules.size()]);
    }

    private boolean containsAny(String[] arr1, String[] arr2) {
        return new ArrayList<String>(Arrays.asList(arr1)).removeAll(Arrays.asList(arr2));
    }

    public Map getExtraAttributesNamespaces() {
        return this.extraAttributesNamespaces;
    }

    public void addExtraAttributeNamespace(String prefix, String namespace) {
        this.extraAttributesNamespaces.put(prefix, namespace);
    }

    public void addExtraInfo(String infoKey, String value) {
        this.extraInfo.put(infoKey, value);
    }

    public Map getExtraInfo() {
        return this.extraInfo;
    }
}

