/*
    A Qt game based on Tic Tac Toe for Maemo
    Copyright (C) 2010  Victor Blazquez Francisco <victor.blazquez@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef SHAPE_H
#define SHAPE_H

#include <QGraphicsWidget>


class Shape : public QGraphicsWidget
{
	public:
		Shape(int pos, QGraphicsItem* parent = 0, Qt::WindowFlags wFlags = 0);
		~Shape() {};
		void addData(int kindOfData, int value);
		int getData(int kindOfData);
		void paint(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget);
		void defineShapeImage(int kind, QChar letter);
	private:
		enum DataInside {
			Positions, Shapes
		};
		enum Positions {
			TopLeft, TopMiddle, TopRight,
			MiddleLeft, MiddleMiddle, MiddleRight,
			BottomLeft, BottomMiddle, BottomRight, All };
		enum Shapes {
			Empty, 
			Machine, // Machine
			Human, // Human
			Img
		};
		QString imgMachine;
		QString imgHuman;
};

#endif // SHAPE_H
