/*
    A Qt game based on Tic Tac Toe for Maemo
    Copyright (C) 2010  Victor Blazquez Francisco <victor.blazquez@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/
#include <QGraphicsView>

#include "graphicsview.h"
#include "graphicsscene.h"

GraphicsView::GraphicsView(QWidget* parent): QGraphicsView(parent)
{
// 	setSceneRect(-345, -130, 790,400);
	setFocusPolicy(Qt::NoFocus);
	setCacheMode(CacheBackground);
	setRenderHint(QPainter::Antialiasing);

	scene = new GraphicsScene(this);
	setScene(scene);
	setSceneRect(-350, -170, 800, 420);
	setBackgroundBrush(Qt::black);
}

GraphicsView::~GraphicsView()
{
	delete scene;
}

void GraphicsView::showEvent(QShowEvent* event)
{
	QGraphicsView::showEvent(event);
	centerOn(100,100);
}

void GraphicsView::changeLevel()
{
	scene->changeLevel();
}

void GraphicsView::restartGame()
{
	scene->restartGame();
}

// void GraphicsView::askUserName()
// {
// 	scene->askUserName();
// }

void GraphicsView::statistics()
{
	scene->statistics();
}

void GraphicsView::changeShape()
{
	scene->changeShape();
}
