/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/* 
 * File:   OptionsDialog.hpp
 * Author: ivan
 *
 * Created on February 23, 2009, 4:10 PM
 */

#pragma once

#include <ting/types.hpp>

#include <gtkmm/dialog.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/box.h>
#include <gtkmm/frame.h>
#include <gtkmm/comboboxtext.h>

#include "utils.hpp"
#include "Preferences.hpp"

class OptionsDialog : public Gtk::Dialog{
	Gtk::RadioButton oneOctaveRadioButton;
	Gtk::RadioButton twoOctavesRadioButton;
	Gtk::RadioButton threeOctavesRadioButton;

	Gtk::ComboBoxText timbreComboBox;

	Gtk::CheckButton lockCurrentOctaveCheckbox;
public:
	OptionsDialog(Gtk::Window &parent, bool theremin = true);

	unsigned GetNumOctaves()const;
	void SetNumOctaves(unsigned num);

	E_Timbre GetTimbre()const;
	void SetTimbre(E_Timbre timbre);

	bool GetLockToTappedOctave()const;
	void SetLockToTappedOctave(bool lockToOctave);
};

