/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */



#include <cstdlib>
#include <cmath>
#include <gtkmm/dialog.h>
#include <gtkmm/main.h>
#include <gtkmm/notebook.h>
#include <gtkmm/box.h>

#include <ting/Exc.hpp>
#include <ting/math.hpp>
#include <ting/Array.hpp>
#include <ting/Ref.hpp>
#include <ting/Ptr.hpp>
#include <pugixml/pugixml.hpp>

#include "stdafx.hpp"
#include "dialogs/AboutDialog.hpp"
#include "dialogs/NetworkSettingsDialog.hpp"
#include "MainWindow.hpp"
#include "File.hpp"
#include "FSFile.hpp"
#include "Preferences.hpp"



using namespace ting;



void MainWindow::ShowNetworkSettingsDialog(){
	NetworkSettingsDialog d(MainWindow::Inst());

	d.set_deletable(false);
	d.run();
	d.hide();
	TRACE(<< "MainWindow::ShowNetworkSettingsDialog(): network settings dialog exited" << std::endl)
}




MainWindow::MainWindow() :
		BasicWindow(true)//pass true because this is a root wondow, it will not be closed by backspace key
{
	this->set_default_size(800, 480);

	Gtk::Box *mainBox = new Gtk::VBox();
	this->add(*Gtk::manage(mainBox));
	mainBox->set_homogeneous(false);

	Gtk::Box *hbox = new Gtk::HBox();
	mainBox->add(*Gtk::manage(hbox));

	{
		Gtk::VBox *vbox = new Gtk::VBox();
		hbox->add(*Gtk::manage(vbox));

		Gtk::Button *tb = new Gtk::Button("Theremin");
		vbox->add(*Gtk::manage(tb));
		tb->signal_clicked().connect(
				sigc::mem_fun(*this, &MainWindow::ShowThereminScreen)
			);

		Gtk::Button *ab = new Gtk::Button("Anglephone");
		vbox->add(*Gtk::manage(ab));
		ab->signal_clicked().connect(
				sigc::mem_fun(*this, &MainWindow::ShowAnglephoneScreen)
			);

		Gtk::Button *kb = new Gtk::Button("Keyboard");
		vbox->add(*Gtk::manage(kb));
		kb->signal_clicked().connect(
				sigc::mem_fun(*this, &MainWindow::ShowKeyboardScreen)
			);
	}

	{
		Gtk::VBox *vbox = new Gtk::VBox();
		hbox->add(*Gtk::manage(vbox));

		Gtk::Button *lb = new Gtk::Button("Listen others");
		vbox->add(*Gtk::manage(lb));
		lb->signal_clicked().connect(
				sigc::mem_fun(*this, &MainWindow::ShowListenOthersScreen)
			);

		Gtk::Button *nb = new Gtk::Button("Network settings");
		vbox->add(*Gtk::manage(nb));
		nb->signal_clicked().connect(
				sigc::mem_fun(*this, &MainWindow::ShowNetworkSettingsDialog)
			);
	}

	{
		Gtk::Label *l = new Gtk::Label("Space = toggle fullscreen");
		mainBox->pack_end(*Gtk::manage(l), false, true);
	}

	this->show_all_children();//Show all window child widgets
}



void MainWindow::Exit(){
	Gtk::Main::quit();
}
