/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */



#include <gtkmm-2.4/gtkmm/menuitem.h>

#include "stdafx.hpp"
#include "dialogs/AboutDialog.hpp"
#include "BasicWindow.hpp"



BasicWindow::BasicWindow(bool rootWindow) :
		isRootWindow(rootWindow),
		isFullscreen(false),
		optionsMenuItem("Settings")
{
	this->set_default_size(800, 480);

	this->signal_key_press_event().connect_notify(
			sigc::mem_fun(*this, &BasicWindow::OnKeyPress_Notify)
		);
	this->signal_key_press_event().connect(
			sigc::mem_fun(*this, &BasicWindow::OnKeyPress)
		);

#ifndef M_NON_MAEMO_LINUX
	this->mainMenu.append(this->optionsMenuItem);
	this->optionsMenuItem.set_sensitive(false);

	{
		Gtk::Button *aboutMenuItem = new Gtk::Button("About");
		this->mainMenu.append(*Gtk::manage(aboutMenuItem));
		aboutMenuItem->signal_clicked().connect(
				sigc::mem_fun(*this, &BasicWindow::ShowAboutDialog)
			);
	}
#else
	//menu
	this->optionsMenuItem.set_size_request(-1, DFingerFriendlyMinSize());
	this->mainMenu.append(this->optionsMenuItem);
	this->optionsMenuItem.set_sensitive(false);

	{
		Gtk::MenuItem *aboutMenuItem = new Gtk::MenuItem("About");
		this->mainMenu.append(*Gtk::manage(aboutMenuItem));
		aboutMenuItem->set_size_request(-1, DFingerFriendlyMinSize());
		aboutMenuItem->signal_activate().connect(
				sigc::mem_fun(*this, &BasicWindow::ShowAboutDialog)
			);
	}
#endif

	this->mainMenu.show_all();//Show the main menu and all its child widgets.
#ifndef M_NON_MAEMO_LINUX
	this->set_app_menu(this->mainMenu);
#else
	this->add(this->mainMenu);
#endif
}



void BasicWindow::ShowAboutDialog(){
	AboutDialog d(*this);
	d.run();
	d.hide();
}



struct MenuPlacer{
	int menuX, menuY;
	void onPopupMenuPosition(int& x, int& y, bool& pushIn){
		x = this->menuX;
		y = this->menuY;
		pushIn = true;
	}
};



void BasicWindow::ToggleFullscreen(){
	if(this->isFullscreen)
		this->unfullscreen();
	else
		this->fullscreen();
	this->isFullscreen = !this->isFullscreen;
}



bool BasicWindow::OnKeyPress(GdkEventKey* event){
	TRACE(<<"BasicWindow::OnKeyPress(): keyval = " << event->keyval << std::endl)
	switch(event->keyval){
		case GDK_BackSpace:
			if(!this->isRootWindow){
				//Backspace closes the window, going back to previous window.
				this->hide();
			}
			break;
		case GDK_F6:
//			TRACE(<<"OnKeyPress(): f6 pressed" << std::endl)
			this->ToggleFullscreen();
			break;
#ifdef M_NON_MAEMO_LINUX
		case GDK_F4:
			{
				Glib::RefPtr<Gdk::Window> window = this->get_window();
				if(!window)
					return false;

				MenuPlacer placer;
				window->get_origin(placer.menuX, placer.menuY);

				this->mainMenu.popup(sigc::mem_fun(placer, &MenuPlacer::onPopupMenuPosition), 0, 0);
			}
			break;
#endif
		default:
			return false;
			break;
	}
	return true;
}


void BasicWindow::OnKeyPress_Notify(GdkEventKey* event){
	TRACE(<<"BasicWindow::OnKeyPress_Notify(): keyval = " << event->keyval << std::endl)
	switch(event->keyval){
		case GDK_space:
			this->ToggleFullscreen();
			break;
		default:
			break;
	}
}


