/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/*
* aumiks 0.1
*/

/*
 * STK library (http://ccrma.stanford.edu/software/stk/index.html) was used as
 * a reference while creating this class.
 */

#pragma once

#include <ting/debug.hpp>
#include <ting/math.hpp>

#include "config.hpp"

namespace aumiks{

class FilterOnePole{
	aumiks::real a0, b1;
	aumiks::real y0, y1;
public:

	FilterOnePole(aumiks::real coefA0 = 0.1, aumiks::real coefB1 = 0.9) :
			a0(coefA0),
			b1(coefB1)
	{
		this->Clear();
	}

	void Clear(){
		this->y0 = 0;
		this->y1 = 0;
	}

	/**
	@brief Set filter pole.
	This method sets filter coefficients so that the filter has the pole
	position along the real-axis of the z-plane and normalizes the
	coefficients for a maximum gain of one.
    A positive pole value produces a low-pass filter, while a negative
    pole value produces a high-pass filter.
	*/
	void SetPole(aumiks::real pole){
		//Normalize coefficients for peak unity gain.
		this->a0 = 1.0 - ting::Abs(pole);
		
		this->b1 = pole;
	}

	inline aumiks::real Tick(aumiks::real sample){
		this->y0 = this->a0 * sample + this->b1 * this->y1;
		this->y1 = this->y0;
		return this->y0;
	}
};

}//~namespace
