/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#ifndef M_NON_MAEMO_LINUX
#include <libosso.h>
#include <hildonmm.h>
#endif

#include <gtkmm/main.h>
#include <gtkmm/settings.h>

#include <ting/debug.hpp>
#include <ting/Fixed.hpp>
#include <ting/Timer.hpp>
#include <ting/Socket.hpp>

#include <aumiks/aumiks.hpp>

#include "MainWindow.hpp"
#include "FSFile.hpp"
#include "Preferences.hpp"
#include "MainThread.hpp"
#include "utils.hpp"


using namespace ting;

int main(int argc, char *argv[]){
//	Fixed<16> a(3);
//	Fixed<16> b(4);
//	Fixed<16> c;
//	c = -a / b;
//	TRACE(
//			<< "a = " << a << std::endl
//			<< "b = " << b << std::endl
//			<< "c = -a / b = " << c << std::endl
//			<< "a * b = " << (a * b) << std::endl
//			<< "b / a = " << (b / a) << std::endl
//			<< "a + b = " << (a + b) << std::endl
//			<< "a - b = " << (a - b) << std::endl
//			<< "b - a = " << (b - a) << std::endl
//			<< "b / c = " << (b / c) << std::endl
//			<< "Sin(0) = " << Fixed<16>(0).Sin() << std::endl
//			<< "Sin(pi/4) = " << Fixed<16>(ting::DPi<float>() / 4).Sin() << std::endl
//			<< "Sin(pi/2) = " << Fixed<16>(ting::DPi<float>() / 2).Sin() << std::endl
//			<< "Sin(pi*3/4) = " << Fixed<16>(ting::DPi<float>() * 3 / 4).Sin() << std::endl
//			<< "Sin(pi) = " << Fixed<16>(ting::DPi<float>()).Sin() << std::endl
//			<< "Sin(pi*5/4) = " << Fixed<16>(ting::DPi<float>() * 5 / 4).Sin() << std::endl
//			<< "Sin(pi*3/2) = " << Fixed<16>(ting::DPi<float>() * 3 / 2).Sin() << std::endl
//			<< "Sin(pi*7/4) = " << Fixed<16>(ting::DPi<float>() * 7 / 4).Sin() << std::endl
//			<< "Sin(2pi) = " << Fixed<16>(ting::D2Pi<float>()).Sin() << std::endl
//		)


//	TRACE(<< int(Fixed<1>(-1.5f)) << std::endl)
//	TRACE(<< int(Fixed<1>(1.13f)) << std::endl)
//
//	TRACE(<< "0.14 % 0.1 = " << (Fixed<16>(0.14f) % Fixed<16>(0.1f)) << std::endl)
//	TRACE(<< "-0.14 % 0.1 = " << (Fixed<16>(-0.14f) % Fixed<16>(0.1f)) << std::endl)
//
//	TRACE(<< "Exp(-13.0) = " << Fixed<16>(-13.0f).ExpSemiTeylor() << " exp = " << exp(-13.0f) << std::endl)
//	TRACE(<< "Exp(-10.0) = " << Fixed<16>(-10.0f).ExpSemiTeylor() << " exp = " << exp(-10.0f) << std::endl)
//	TRACE(<< "Exp(-0.14) = " << Fixed<16>(-0.14f).ExpSemiTeylor() << " exp = " << exp(-0.14f) << std::endl)
//	TRACE(<< "Exp(-0.1) = " << Fixed<16>(-0.1f).ExpSemiTeylor() << " exp = " << exp(-0.1f) << std::endl)
//	TRACE(<< "Exp(-0.099) = " << Fixed<16>(-0.099f).ExpSemiTeylor() << " exp = " << exp(-0.099f) << std::endl)
//	TRACE(<< "Exp(-0.08) = " << Fixed<16>(-0.08f).ExpSemiTeylor() << " exp = " << exp(-0.08f) << std::endl)
//	TRACE(<< "Exp(-0.03) = " << Fixed<16>(-0.03f).ExpSemiTeylor() << " exp = " << exp(-0.03f) << std::endl)
//
//	TRACE(
//			<< "Exp(0) = " << Fixed<16>(0).ExpSemiTeylor() << " exp = " << exp(0) << std::endl
//			<< "Exp(0.001) = " << Fixed<16>(0.001f).ExpSemiTeylor() << " exp = " << exp(0.001f) << std::endl
//			<< "Exp(0.02) = " << Fixed<16>(0.02f).ExpSemiTeylor() << " exp = " << exp(0.02f) << std::endl
//			<< "Exp(0.1) = " << Fixed<16>(0.1f).ExpSemiTeylor() << " exp = " << exp(0.1f) << std::endl
//			<< "Exp(0.2) = " << Fixed<16>(0.2f).ExpSemiTeylor() << " exp = " << exp(0.2f) << std::endl
//			<< "Exp(0.3) = " << Fixed<16>(0.3f).ExpSemiTeylor() << " exp = " << exp(0.3f) << std::endl
//			<< "Exp(0.4) = " << Fixed<16>(0.4f).ExpSemiTeylor() << " exp = " << exp(0.4f) << std::endl
//			<< "Exp(0.499) = " << Fixed<16>(0.499f).ExpSemiTeylor() << " exp = " << exp(0.499f) << std::endl
//			<< "Exp(0.5) = " << Fixed<16>(0.5f).ExpSemiTeylor() << " exp = " << exp(0.5f) << std::endl
//			<< "Exp(0.7) = " << Fixed<16>(0.7f).ExpSemiTeylor() << " exp = " << exp(0.7f) << std::endl
//			<< "Exp(1) = " << Fixed<16>(1).ExpSemiTeylor() << " exp = " << exp(1) << std::endl
//			<< "Exp(1.3) = " << Fixed<16>(1.3f).ExpSemiTeylor() << " exp = " << exp(1.3f) << std::endl
//			<< "Exp(1.5) = " << Fixed<16>(1.5f).ExpSemiTeylor() << " exp = " << exp(1.5f) << std::endl
//
//			<< "Exp(10) = " << Fixed<16>(10).ExpSemiTeylor() << " exp = " << exp(10) << std::endl
//			<< "Exp(19.99) = " << Fixed<16>(19.99f).ExpSemiTeylor() << " exp = " << exp(19.99f) << std::endl
//			<< "Exp(24) = " << Fixed<16>(24).ExpSemiTeylor() << " exp = " << exp(24) << std::endl
//		)

//	byte e[2];
//	*reinterpret_cast<u16*>(e) = u16(0x0102);
//
//	TRACE(<<"e[2] (*" << reinterpret_cast<void*>(e) << ") = " << u32(e[0]) << " " << u32(e[1]) << std::endl)
//
//	byte b[4];
//	*reinterpret_cast<u32*>(b) = u32(0x01020304);
//
//	TRACE(<<"b[4] (*" << reinterpret_cast<void*>(b) << ") = " << u32(b[0]) << " " << u32(b[1]) << " " << u32(b[2]) << " " << u32(b[3]) << std::endl)


	TRACE(<<"Program start"<<std::endl)

	ting::TimerLib timerLib;

	//init network
    ting::SocketLib socketLib;

	//Create .theremin directory in user's home if it does not exist
	{
		file::FSFile dir(file::File::GetHomeDir() + ".theremin/");
		if(!dir.Exists()){
			TRACE(<<"dir does not exist"<<std::endl)
			dir.MkDir();
		}else{
			TRACE(<<"dir already exists"<<std::endl)
		}
	}

	TRACE(<<"creating sndlib"<<std::endl)
#ifndef M_NO_AUDIO
	aumiks::Lib sndlib(2048);
#endif

	// Initialize gtkmm:
	Gtk::Main kit(&argc, &argv);

	//TODO: add icons to buttons
//	Gtk::Settings::get_default()->property_gtk_button_images() = true;

	//create Glibdispatcher singleton
	GlibDispatcher glibDispatcherSingleton;

#ifndef M_NON_MAEMO_LINUX
	Hildon::init();

	osso_context_t* osso_context = osso_initialize(
			"org.maemo.garage.theremin",
			"1.4.0",
			TRUE /* deprecated parameter */,
			0 /* Use default Glib main loop context */
		);
	if(!osso_context){
		TRACE(<< "osso_initialize() failed." << std::endl)
		throw ting::Exc("osso_initialize() failed.");
	}
#endif

	Glib::set_application_name("Theremin");//shown in main window caption

	//create preferences object
	Preferences preferences("preferences.xml");

	if(argc >= 2){
		preferences.serverHost = std::string(argv[1]);
	}else{
		preferences.serverHost = std::string("188.120.242.144");
	}

	if(argc >= 3){
		preferences.serverPort = atoi(argv[2]);
	}else{
		preferences.serverPort = 13666;
	}

	preferences.LoadFromFile();

	MainThread mainThread;

	//Create main window
	MainWindow window;
	TRACE(<< "main(): window created" << std::endl)

	//Set the window to the Program instance()
#ifndef M_NON_MAEMO_LINUX
	Hildon::Program::get_instance()->add_window(window);
	TRACE(<< "main(): window added" << std::endl)
#endif

	mainThread.Start();

	// Begin the main application
	kit.run(window);
	TRACE(<< "main(): kit.run() returned" << std::endl)

	//signal main thread to quit
	mainThread.PushQuitMessage();

	preferences.SaveToFile();

#ifndef M_NON_MAEMO_LINUX
	osso_deinitialize(osso_context);
#endif

	//make sure the main thread has finished
	mainThread.Join();

	TRACE(<< "main(): exiting" << std::endl)
	return 0;
}
