#include <glibmm-2.4/glibmm/dispatcher.h>

#include "utils.hpp"



using namespace ting;



GlibDispatcher::GlibDispatcher() :
		nextId(0)
{
	//connect dispatcher
	this->glibDispatcher.connect(
			sigc::mem_fun(*this, &GlibDispatcher::GlibDispatcherHandler)
		);
}



ting::uint GlibDispatcher::Connect(ting::Ptr<ting::Signal0> signal){
	Mutex::Guard mutexGuard(this->mutex);

	ting::uint id = this->nextId;

	this->sigMap.insert(std::pair<ting::uint, Ptr<Signal0> >(id, signal));

	++this->nextId;
	ASSERT(this->nextId != 0) //no warp
	
	return id;
}



void GlibDispatcher::Disconnect(ting::uint id){
	Mutex::Guard mutexGuard(this->mutex);

	T_SigIter i = this->sigMap.find(id);

	if(i == this->sigMap.end()){
		ASSERT_INFO(false, "signal id not found")
		return;
	}

	this->sigMap.erase(i);
}



void GlibDispatcher::GlibDispatcherHandler(){
	Mutex::Guard mutexGuard(this->mutex);

	ting::uint id = this->glibDispatcherArg.front();
	this->glibDispatcherArg.pop_front();

	T_SigIter i = this->sigMap.find(id);
	if(i == this->sigMap.end()){
		//signal id not found, probably it was disconnected
		TRACE(<< "GlibDispatcher::GlibDispatcherHandler(): signal id not found, probably it was disconnected" << std::endl)
		return;
	}

	i->second->Emit();
}



void GlibDispatcher::Emit(ting::uint id){
	Mutex::Guard mutexGuard(this->mutex);

	this->glibDispatcherArg.push_back(id);
	this->glibDispatcher.emit();
}


