/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#include "AboutDialog.hpp"


AboutDialog::AboutDialog(Gtk::Window &parent) :
		Gtk::Dialog("About", parent, true)
{
	this->aboutText.set_markup(
			"<span foreground=\"darkred\" size=\"larger\">Maemo Theremin v1.4</span>\n"
			"\n"
			"A touchscreen musical instrument.\n"
			"\n"
			"<small>Project homepage:</small>\n"
			"\t<span foreground=\"darkblue\">http://theremin.garage.maemo.org</span>\n"
			"\n"
			"<small>Copyright 2009 Ivan Gagis &lt;igagis@gmail.com&gt;</small>"
		);
	this->get_vbox()->add(this->aboutText);
//	this->aboutText.show();

	this->add_button("Ok", 0);

	this->show_all_children();//Show all window child widgets
};
