#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    progress(tr("Setting up the theme, please wait..."), tr("Abort"), 0, 100, this),
    progress2(tr("Searching and importing fonts, please wait..."), tr("Abort"), 0, 0, this),
    progress3(tr("Reading settings..."), tr("Abort"), 0, 100, this),
    progress4(tr("Restoring files, please wait..."), tr("Abort"), 0, 0, this),
    colors()
{
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);
    QString varattu3;
    varattu3 = tr("Reading settings");
    progress3.setWindowModality(Qt::WindowModal);
    progress3.setWindowTitle(varattu3);
    progress3.setCancelButton(0);
    progress3.setValue(0);
    progress3.show();
    progress3.setValue(5);
    lastpath = "/home/user/MyDocs";
    readdirs();
    oldfonts("/etc/hildon/theme/colors.config");
    progress3.setValue(20);
    readgtkrc();
    progress3.setValue(30);
    QRegExp regexer("^\\#[0-9a-fA-F]{6,6}$");
    progress3.setValue(35);
    QRegExp regexer_icon("^[0-9]{2,3}$");
    QRegExp regexer_opaasi("^[0-9]{1,3}$");
    progress3.setValue(45);
    QRegExp regexer_book("^[0-9]{2,3}$");
    progress3.setValue(50);
    QRegExp regexer_snap("^[0-9]{1,2}$");
    progress3.setValue(60);
    ui->font1->setValidator(new QRegExpValidator(regexer, ui->font1));
    ui->font2->setValidator(new QRegExpValidator(regexer, ui->font2));
    ui->font3->setValidator(new QRegExpValidator(regexer, ui->font3));
    ui->font4->setValidator(new QRegExpValidator(regexer, ui->font4));
    ui->font5->setValidator(new QRegExpValidator(regexer, ui->font5));
    ui->font6->setValidator(new QRegExpValidator(regexer, ui->font6));
    ui->font7->setValidator(new QRegExpValidator(regexer, ui->font7));
    ui->font8->setValidator(new QRegExpValidator(regexer, ui->font8));
    progress3.setValue(70);
    ui->lineEdit->setValidator(new QRegExpValidator(regexer_icon, ui->lineEdit));
    ui->lineEdit_2->setValidator(new QRegExpValidator(regexer_book, ui->lineEdit_2));
    ui->Snap->setValidator(new QRegExpValidator(regexer_snap, ui->Snap));
    ui->Opacity->setValidator(new QRegExpValidator(regexer_opaasi, ui->Opacity));
    ui->Opacity_top->setValidator(new QRegExpValidator(regexer_opaasi, ui->Opacity_top));
    progress3.setValue(80);
    readSettings();
    progress3.setValue(100);
    progress3.cancel();

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::oldfonts(QString preset)
{

    QFile file(preset);
    file.open(QFile::ReadOnly);

    QTextStream stream ( &file );
    QString line;
    QHash<QString, QString> variables;
    do {
        line = stream.readLine();

        QStringList splittedLine = line.split("=");

        if (splittedLine.count()==2) {
        variables.insert(splittedLine.at(0), splittedLine.at(1));
    }
    } while (!line.isNull());

    file.close();

    fonts.clear();
    fonts.append(variables.value("DefaultTextColor"));
    fonts.append(variables.value("SecondaryTextColor"));
    fonts.append(variables.value("ActiveTextColor"));
    fonts.append(variables.value("DisabledTextColor"));


    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    const QString COLOR_STYLE2("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    ui->fontprimary->setStyleSheet(COLOR_STYLE.arg(variables.value("DefaultTextColor"), variables.value("DefaultBackgroundColor"), variables.value("DefaultTextColor")));
    ui->font1->setText(variables.value("DefaultTextColor"));
    f1=variables.value("DefaultTextColor");

    ui->fontsecondary->setStyleSheet(COLOR_STYLE.arg(variables.value("SecondaryTextColor"), variables.value("DefaultBackgroundColor"), variables.value("SecondaryTextColor")));
    ui->font2->setText(variables.value("SecondaryTextColor"));
    f2=variables.value("SecondaryTextColor");

    ui->fontactive->setStyleSheet(COLOR_STYLE.arg(variables.value("ActiveTextColor"), variables.value("DefaultBackgroundColor"), variables.value("ActiveTextColor")));
    ui->font3->setText(variables.value("ActiveTextColor"));
    f3=variables.value("ActiveTextColor");

    ui->fontdisabled->setStyleSheet(COLOR_STYLE.arg(variables.value("DisabledTextColor"), variables.value("DefaultBackgroundColor"), variables.value("DisabledTextColor")));
    ui->font4->setText(variables.value("DisabledTextColor"));
    f4=variables.value("DisabledTextColor");

    ui->fontpainted->setStyleSheet(COLOR_STYLE2.arg(variables.value("PaintedTextColor"), variables.value("SelectionColor"), variables.value("PaintedTextColor")));
    ui->font5->setText(variables.value("PaintedTextColor"));
    f5=variables.value("PaintedTextColor");

    ui->fontdisabled_2->setStyleSheet(COLOR_STYLE.arg(variables.value("SelectionColor"), variables.value("DefaultBackgroundColor"), variables.value("SelectionColor")));
    ui->font6->setText(variables.value("SelectionColor"));
    f6=variables.value("SelectionColor");

    ui->fontbutton->setStyleSheet(COLOR_STYLE.arg(variables.value("ButtonTextColor"), variables.value("DefaultBackgroundColor"), variables.value("ButtonTextColor")));
    ui->font7->setText(variables.value("ButtonTextColor"));
    f7=variables.value("ButtonTextColor");

    ui->fontbuttonpressed->setStyleSheet(COLOR_STYLE.arg(variables.value("ButtonTextPressedColor"), variables.value("DefaultBackgroundColor"), variables.value("ButtonTextPressedColor")));
    ui->font8->setText(variables.value("ButtonTextPressedColor"));
    f8=variables.value("ButtonTextPressedColor");
}

void MainWindow::readdirs()
{
    ui->Iconset->clear();
    QDir colors("/usr/share/icons");   
    QStringList temp = colors.entryList(QDir::AllDirs | QDir::NoDotAndDotDot, QDir::DirsFirst);
    QStringList colorstobox;
    int count = temp.count();
    for(int i=0;i<count;i++)
    {
        if (QFile::exists("/usr/share/icons/" + temp.at(i) + "/index.theme")) {
            ui->Iconset->addItem(temp.at(i));
        }
    }
}

void MainWindow::readgtkrc()
{
    QFile file2("/etc/hildon/theme/gtk-2.0/gtkrc");
    file2.open(QFile::ReadOnly);

    QTextStream stream2 ( &file2 );
    QString line2;
    QHash<QString, QString> gtkrc;
    do {
        line2 = stream2.readLine();

        QStringList splittedLine = line2.split("=");

        if (splittedLine.count()==2) {
        gtkrc.insert(splittedLine.at(0), splittedLine.at(1));
    }
    } while (!line2.isNull());

    file2.close();

    QString icontheme;
    icontheme = gtkrc.value("gtk-icon-theme-name ");
    icontheme.remove(QChar('\"'));
    icontheme.remove(QChar(' '));
    icontheme.simplified();

    currenttheme = gtkrc.value("gtk-theme-name ");
    currenttheme.remove(QChar('\"'));
    currenttheme.simplified();

    int indeksi = ui->Iconset->findText(icontheme);
    ui->Iconset->setCurrentIndex(indeksi);

    ui->label->setText(tr("Current theme: ") + currenttheme);
}

void MainWindow::writeSettings()
{
    QSettings sett("ThemeCustomizer", "Boxes");
    QSettings themesett("ThemeCustomizer", currenttheme);
    sett.setValue("snap", ui->Snap->text());
    themesett.setValue("fontsize", ui->FontSize->currentIndex());
    sett.setValue("iconset", ui->Iconset->currentIndex());
    sett.setValue("appsize", ui->lineEdit->text());
    sett.setValue("booksize", ui->lineEdit_2->text());
    themesett.setValue("opacity", ui->Opacity->text());
    themesett.setValue("opacity_top", ui->Opacity_top->text());

    QString Icons;
    if ( ui->Icons->checkState() == Qt::Checked ) {
        sett.setValue("icons", "1");
    }
    else {
        sett.setValue("icons", "0");
    }

    QString Transitions;
    if ( ui->transitions->checkState() == Qt::Checked ) {
        themesett.setValue("transitions", "1");
    }
    else {
        themesett.setValue("transitions", "0");
    }
}

void MainWindow::readSettings()
{
    QSettings sett("ThemeCustomizer", "Boxes");
    QSettings themesett("ThemeCustomizer", currenttheme);
    int icons = sett.value("icons").toInt();
    int transitions = themesett.value("transitions").toInt();
    int snap = sett.value("snap").toInt();
    int fontsize = themesett.value("fontsize").toInt();
    QString fontsizestring = themesett.value("fontsize").toString();
//    int iconset = sett.value("iconset").toInt();
    int appsize = sett.value("appsize").toInt();
    int booksize = sett.value("booksize").toInt();
    int opacity = themesett.value("opacity").toInt();
    int opacity_top = themesett.value("opacity_top").toInt();
    QString appsizestring = sett.value("appsize").toString();
    QString booksizestring = sett.value("booksize").toString();
    QString snapstring = sett.value("snap").toString();
    QString opacitystring = themesett.value("opacity").toString();
    QString opacitystring_top = themesett.value("opacity_top").toString();
    // ui->Icons->setCurrentIndex(icons);
    // ui->Snap->setCurrentIndex(snap);

    if ( icons == 1 ) {
        ui->Icons->setCheckState(Qt::Checked);
    } else {
        ui->Icons->setCheckState(Qt::Unchecked);
    }

    if ( transitions == 1 ) {
        ui->transitions->setCheckState(Qt::Checked);
    } else {
        ui->transitions->setCheckState(Qt::Unchecked);
    }

    if ( !fontsizestring.isEmpty() ) {
    ui->FontSize->setCurrentIndex(fontsize);
    }

    if ( appsize > 15 ) {
    ui->lineEdit->setText(appsizestring);
    ui->horizontalSlider->setValue(appsize);
    }

    if ( booksize > 25 ) {
    ui->lineEdit_2->setText(booksizestring);
    ui->horizontalSlider_2->setValue(booksize);
    }

    if ( snap > 3 ) {
    ui->Snap->setText(snapstring);
    ui->horizontalSlider_3->setValue(snap);
    }

    if ( !opacitystring.isEmpty() ) {
    ui->Opacity->setText(opacitystring);
    ui->horizontalSlider_4->setValue(opacity);
    } else {
    ui->Opacity->setText("255");
    ui->horizontalSlider_4->setValue(255);
    }

    if ( !opacitystring_top.isEmpty() ) {
    ui->Opacity_top->setText(opacitystring_top);
    ui->horizontalSlider_5->setValue(opacity_top);
} else {
    ui->Opacity_top->setText("255");
    ui->horizontalSlider_5->setValue(255);
}

}

void MainWindow::SetOpacity(QString imagefile, int opacity)
{

    QPixmap temp;
    QString realimagefile = QFileInfo("/etc/hildon/theme/images/" + imagefile).canonicalFilePath();
    QString imagebackup = "/opt/theme-customizer/backups/" + realimagefile;
    temp = QPixmap(imagebackup);
    QPixmap transparent(temp.size());
    transparent.fill(Qt::transparent);
    QPainter p(&transparent);
    p.setCompositionMode(QPainter::CompositionMode_Source);
    p.drawPixmap(0, 0, temp);
    p.setCompositionMode(QPainter::CompositionMode_DestinationIn);
    p.fillRect(transparent.rect(), QColor(0, 0, 0, opacity));  // opacity value can be 0-255
    p.end();
    // Save the new image
    transparent.save(realimagefile);
    // system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:'Image saved!' uint32:0 string:'OK'");

}

void MainWindow::on_pushButton_clicked()
{
        if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
            checkboxstate = "Reboot";
        }
        else {
            checkboxstate = "0";
        }

        if ( ui->Icons->checkState() == Qt::Checked ) {
            Icons = "Show icons";
        }
        else {
            Icons = "Don't show icon backgrounds";
        }

        if ( ui->transitions->checkState() == Qt::Checked ) {
            Transitions = "1";
        }
        else {
            Transitions = "0";
        }

        runscript("0");

}

void MainWindow::clean()
{
QString directory_path = "/opt/theme-customizer/backups/";

QDirIterator directory_walker(directory_path, QDir::Files | QDir::Dirs | QDir::NoDotAndDotDot, QDirIterator::Subdirectories);

while(directory_walker.hasNext())
{
      directory_walker.next();

     QString filee_orig = directory_walker.filePath();
     QString filee = filee_orig;
     filee.remove("/opt/theme-customizer/backups");
     QDir backupfile(filee_orig);
     QFileInfo info = filee_orig;

     if (!QFile::exists(filee)) {
    //     QMaemo5InformationBox::information(this, "Alkuperist: " + filee + " ei lydy, poistetaan: " + filee_orig, QMaemo5InformationBox::NoTimeout);
         if (info.isDir()) {
             backupfile.rmdir(filee_orig);
         } else if (info.isFile()) {
             QFile::remove(filee_orig);
         }

     }

}
}

void MainWindow::runscript(QString command)
{

    QString varattu;
    varattu = "Theme Customizer";
    progress.setWindowModality(Qt::WindowModal);
    progress.setWindowTitle(varattu);
    progress.setCancelButton(0);
    progress.show();
    progress.setValue(1);
    QStringList arguments;
    arguments << ui->FontSize->currentText() << ui->Fonter->currentText() << ui->Iconset->currentText() << Icons << ui->lineEdit->text() << ui->Snap->text() << checkboxstate << fonts << f1 << f2 << f3 << f4 << ui->lineEdit_2->text() << f5 << f6 << f7 << f8 << ui->Opacity->text();

    if ( saveasnew == "1" ) {

                progress.setLabelText(tr("Saving new theme..."));
                progress.setValue(2);
                progress.setValue(3);
                progress.setValue(4);
                QStringList systemcommand;
                systemcommand << "saveasnew" << themename << themedir;
                QProcess *muoks0 = new QProcess(this);
                muoks0->start("/sbin/launchcustomizer", systemcommand);
                muoks0->waitForFinished();
                progress.setValue(5);
                saveasnew = "0";
                readgtkrc();
    }

    if ( command == "saveonly" ) {
        progress.setValue(10);
        progress.setValue(15);
        progress.setValue(20);
        progress.setValue(25);
        readdirs();
        progress.setValue(30);
        progress.setValue(35);
        oldfonts("/etc/hildon/theme/colors.config");
        progress.setValue(40);
        readgtkrc();
        progress.setValue(45);
        progress.setValue(50);
        readSettings();
        progress.setValue(55);
        progress.setValue(60);
        progress.setValue(70);
        progress.setValue(80);
        writeSettings();
        progress.setValue(90);
        progress.cancel();
        QMaemo5InformationBox::information(this, tr("New theme saved!"), QMaemo5InformationBox::DefaultTimeout);
        return;

    }
    writeSettings();

    progress.setLabelText(tr("Creating backups..."));
    progress.setValue(6);
    progress.setValue(7);
    progress.setValue(8);
    QStringList systemcommand;
    systemcommand << "createbackups";
    QProcess *muoks1 = new QProcess(this);
    muoks1->start("/sbin/launchcustomizer", systemcommand);
    muoks1->waitForFinished();
    progress.setValue(10);
    clean();
    clean();

//        QMaemo5InformationBox::information(this, tr("Setting up font family..."), 1);
    progress.setLabelText(tr("Setting up font family..."));
//        sleep(2);
    progress.setValue(12);
    progress.setValue(14);
    progress.setValue(16);
    progress.setValue(18);
    systemcommand.clear();
    systemcommand << "setfontfamily" << ui->Fonter->currentText();
    QProcess *muoks2 = new QProcess(this);
    muoks2->start("/sbin/launchcustomizer", systemcommand);
    muoks2->waitForFinished();
    progress.setValue(20);

//        QMaemo5InformationBox::information(this, tr("Setting up font sizes..."), 1);
    progress.setLabelText(tr("Setting up font sizes..."));
//        sleep(2);
    progress.setValue(22);
    progress.setValue(24);
    progress.setValue(26);
    progress.setValue(28);
    systemcommand.clear();
    systemcommand << "setfontsize" << ui->FontSize->currentText();
    QProcess *muoks3 = new QProcess(this);
    muoks3->start("/sbin/launchcustomizer", systemcommand);
    muoks3->waitForFinished();
    progress.setValue(30);

//        QMaemo5InformationBox::information(this, tr("Setting up font colors..."), 1);
    progress.setLabelText(tr("Setting up font colors..."));
//        sleep(2);
    progress.setValue(32);
    progress.setValue(34);
    progress.setValue(36);
    progress.setValue(38);
    systemcommand.clear();
    systemcommand << "setfontcolors" << f1 << f2 << f3 << f4 << f5 << f6 << f7 << f8;
    QProcess *muoks4 = new QProcess(this);
    muoks4->start("/sbin/launchcustomizer", systemcommand);
    muoks4->waitForFinished();
    progress.setValue(40);

//        QMaemo5InformationBox::information(this, tr("Setting up icon theme..."), 1);
    progress.setLabelText(tr("Setting up icon theme..."));
//        sleep(2);
    progress.setValue(42);
    progress.setValue(44);
    progress.setValue(46);
    progress.setValue(48);
    systemcommand.clear();
    systemcommand << "seticontheme" << ui->Iconset->currentText();
    QProcess *muoks5 = new QProcess(this);
    muoks5->start("/sbin/launchcustomizer", systemcommand);
    muoks5->waitForFinished();
    progress.setValue(50);

    progress.setLabelText(tr("Setting up window transitions"));
    systemcommand.clear();
    systemcommand << "settransitions" << Transitions;
    QProcess *muoks8 = new QProcess(this);
    muoks8->start("/sbin/launchcustomizer", systemcommand);
    muoks8->waitForFinished();

    progress.setValue(52);
    progress.setValue(54);
    progress.setValue(56);
    progress.setValue(58);
    progress.setLabelText(tr("Setting up snap-to-grid..."));
    systemcommand.clear();
    systemcommand << "setsnaptogrid" << ui->Snap->text();
    QProcess *muoks6 = new QProcess(this);
    muoks6->start("/sbin/launchcustomizer", systemcommand);
    muoks6->waitForFinished();
    progress.setValue(60);

    progress.setValue(62);
    progress.setValue(64);
    progress.setValue(66);
    progress.setValue(68);
    progress.setLabelText(tr("Setting up shortcut and bookmark sizes..."));
    systemcommand.clear();
    systemcommand << "seticonsizes" << ui->lineEdit->text() << ui->lineEdit_2->text() << Icons;
    QProcess *muoks7 = new QProcess(this);
    muoks7->start("/sbin/launchcustomizer", systemcommand);
    muoks7->waitForFinished();
    progress.setValue(70);

    int opasity = ui->Opacity->text().toInt();
    int opasity_top = ui->Opacity_top->text().toInt();
//       QMaemo5InformationBox::information(this, tr("Setting up widget opacities..."), 1);
    progress.setLabelText(tr("Setting up widget opacities..."));
    progress.setValue(72);
    progress.setValue(74);
    progress.setValue(76);
    progress.setValue(78);
    SetOpacity("ApplicationShortcutApplet.png", opasity);
    SetOpacity("CalendarAppletBackground.png", opasity);
    SetOpacity("ContactsAppletFrame.png", opasity);
    SetOpacity("MapAppletButton.png", opasity);
    SetOpacity("MapAppletHead.png", opasity);
    SetOpacity("MediaPlayerAppletHead.png", opasity);
    progress.setValue(80);
    SetOpacity("MediaPlayerAppletNext.png", opasity);
    SetOpacity("MediaPlayerAppletPrevious.png", opasity);
    SetOpacity("MediaPlayerAppletStopPlay.png", opasity);
    SetOpacity("OviCenter.png", opasity);
    progress.setValue(82);
    progress.setValue(84);
    SetOpacity("OviLeft.png", opasity);
    SetOpacity("OviRight.png", opasity);
    SetOpacity("RSSAppletHead.png", opasity);
    SetOpacity("WebShortcutAppletBackground.png", opasity);
    SetOpacity("wmLeftButtonAttached.png", opasity_top);
    SetOpacity("wmLeftButtonEnd.png", opasity_top);
    SetOpacity("wmRightButton.png", opasity_top);
    SetOpacity("wmButtonRightHalf.png", opasity_top);
    SetOpacity("wmButtonLeftHalf.png", opasity_top);
    progress.setValue(86);
    progress.setValue(88);


    if ( ui->checkBoxActivate->checkState() == Qt::Unchecked ) {

        progress.setLabelText(tr("Restarting services..."));
        progress.setValue(90);
  //      sleep(1);
  //      QMaemo5InformationBox::information(this, tr("Restarting services, your screen will blink! Rebooting the device is recommended to reload all new values."), QMaemo5InformationBox::DefaultTimeout);
        system("ps ax | grep -v grep | grep osso-abook-home-applet > /dev/null && killall osso-abook-home-applet && sleep 2 &&  ps ax | grep -v grep | grep osso-abook-home-applet || /usr/sbin/dsmetool -t /usr/bin/osso-abook-home-applet");
        sleep(1);
        system("killall systemui");
        sleep(1);
        system("killall browser browserd");
        sleep(1);
        system("killall rtcom-messaging-ui");
        progress.setValue(95);
        sleep(1);
        system("killall rtcom-call-ui");
        sleep(1);
        systemcommand.clear();
        systemcommand << "restartservices";
	QProcess *muoks8 = new QProcess(this);
	muoks8->start("/sbin/launchcustomizer", systemcommand);
	muoks8->waitForFinished();
	sleep(2);
        system("killall theme-customizer");

    } else {

    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Rebooting in 5 seconds, fasten your seatbelts!'");
    system("/sbin/launchcustomizer rebootnow");
    progress.setValue(99);
 //   progress.cancel();
    // oldfonts();

}

}

void MainWindow::on_horizontalSlider_valueChanged(int value)
{
    QString slaideri = QString::number(value);
    ui->lineEdit->setText(slaideri);
}

void MainWindow::on_horizontalSlider_2_valueChanged(int value)
{
    QString slaideri2 = QString::number(value);
    ui->lineEdit_2->setText(slaideri2);
}

void MainWindow::on_horizontalSlider_3_valueChanged(int value)
{
    QString slaideri3 = QString::number(value);
    ui->Snap->setText(slaideri3);
}

void MainWindow::on_horizontalSlider_4_valueChanged(int value)
{
    QString slaideri4 = QString::number(value);
    ui->Opacity->setText(slaideri4);
}

void MainWindow::on_horizontalSlider_5_valueChanged(int value)
{
    QString slaideri5 = QString::number(value);
    ui->Opacity_top->setText(slaideri5);
}

void MainWindow::on_fontprimary_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f1;
    QColor color1 = colors.getColor(current.name());

    if (!color1.isValid()) return;
    f1 = color1.name();
    ui->fontprimary->setStyleSheet(COLOR_STYLE.arg(f1, variables.value("DefaultBackgroundColor"), f1));
    ui->font1->setText(f1);
}


void MainWindow::on_fontsecondary_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f2;
    QColor color2 = colors.getColor(current.name());


    if (!color2.isValid()) return;
    f2 = color2.name();
    ui->fontsecondary->setStyleSheet(COLOR_STYLE.arg(f2, variables.value("DefaultBackgroundColor"), f2));
    ui->font2->setText(f2);
}

void MainWindow::on_fontactive_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f3;
    QColor color3 = colors.getColor(current.name());


    if (!color3.isValid()) return;
    f3 = color3.name();
    ui->fontactive->setStyleSheet(COLOR_STYLE.arg(f3, variables.value("DefaultBackgroundColor"), f3));
    ui->font3->setText(f3);
}

void MainWindow::on_fontdisabled_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f4;
    QColor color4 = colors.getColor(current.name());


    if (!color4.isValid()) return;
    f4 = color4.name();
    ui->fontdisabled->setStyleSheet(COLOR_STYLE.arg(f4, variables.value("DefaultBackgroundColor"), f4));
    ui->font4->setText(f4);
}

void MainWindow::on_fontpainted_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f5;
    QColor color5 = colors.getColor(current.name());


    if (!color5.isValid()) return;
    f5 = color5.name();
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
    ui->font5->setText(f5);
}

void MainWindow::on_fontdisabled_2_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f6;
    QColor color6 = colors.getColor(current.name());


    if (!color6.isValid()) return;
    f6 = color6.name();
    ui->fontdisabled_2->setStyleSheet(COLOR_STYLE.arg(f6, variables.value("DefaultBackgroundColor"), f6));
    ui->font6->setText(f6);
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
}

void MainWindow::on_fontbutton_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f7;
    QColor color7 = colors.getColor(current.name());


    if (!color7.isValid()) return;
    f7 = color7.name();
    ui->fontbutton->setStyleSheet(COLOR_STYLE.arg(f7, variables.value("DefaultBackgroundColor"), f7));
    ui->font7->setText(f7);
}

void MainWindow::on_fontbuttonpressed_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f8;
    QColor color8 = colors.getColor(current.name());


    if (!color8.isValid()) return;
    f8 = color8.name();
    ui->fontbuttonpressed->setStyleSheet(COLOR_STYLE.arg(f8, variables.value("DefaultBackgroundColor"), f8));
    ui->font8->setText(f8);
}

void MainWindow::on_lineEdit_editingFinished()
{
    QString slvalue = ui->lineEdit->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider->setValue(svalue);
}

void MainWindow::on_lineEdit_2_editingFinished()
{
    QString slvalue = ui->lineEdit_2->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_2->setValue(svalue);
}

void MainWindow::on_Snap_editingFinished()
{
    QString slvalue = ui->Snap->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_3->setValue(svalue);
}

void MainWindow::on_Opacity_editingFinished()
{
    QString slvalue = ui->Opacity->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_4->setValue(svalue);
}

void MainWindow::on_Opacity_top_editingFinished()
{
    QString slvalue = ui->Opacity_top->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_5->setValue(svalue);
}

void MainWindow::on_checkBoxActivate_stateChanged(int )
{
    if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
        ui->pushButton->setText(tr("Save and reboot"));
    }
    else {
        ui->pushButton->setText(tr("Apply changes"));
    }
}

void MainWindow::on_fontimport_triggered()
{
    QString fontdir = QFileDialog::getExistingDirectory(this, "Select folder containing fonts", lastpath, QFileDialog::ShowDirsOnly);
    if (fontdir.isEmpty()) return;

    lastpath = fontdir;
    QString varattu2;
    varattu2 = tr("Importing fonts");
    progress2.setWindowModality(Qt::WindowModal);
    progress2.setWindowTitle(varattu2);
    progress2.setCancelButton(0);
    QStringList arguments2;
    arguments2 << "importfontspushed" << fontdir;
    QProcess *process2 = new QProcess(this);
    connect(process2, SIGNAL(finished(int)), this, SLOT(process2Finished(int)));
    process2->start("/sbin/launchcustomizer", arguments2);
    progress2.show();
}

void MainWindow::process2Finished(int)
{
    progress2.cancel();
}

void MainWindow::on_about_triggered()
{
    QMessageBox msgBox;

    msgBox.setWindowTitle(tr("About Theme Customizer"));
    msgBox.setText("Author: d-iivil - Licence: Freeware & open source (GPL)");
    msgBox.setTextFormat(Qt::RichText);
    msgBox.setInformativeText("<html>Version: 0.9-58<br /><a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=ricky%40hevikaraoke%2efi&lc=FI&item_name=Here%27s%20some%20money%20for%20beer%2e&no_note=0&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHostedGuest\">Be a nice guy and <b>donate some money for beer</b> to author</a></html>");
    msgBox.setStandardButtons(QMessageBox::Ok);
    msgBox.setDefaultButton(QMessageBox::Ok);
    msgBox.button(msgBox.Ok)->setText(tr("Ok, thanks."));
    msgBox.exec();
}

void MainWindow::on_font1_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f1 = ui->font1->text();
    ui->fontprimary->setStyleSheet(COLOR_STYLE.arg(f1, variables.value("DefaultBackgroundColor"), f1));

}

void MainWindow::on_font2_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f2 = ui->font2->text();
    ui->fontsecondary->setStyleSheet(COLOR_STYLE.arg(f2, variables.value("DefaultBackgroundColor"), f2));
}

void MainWindow::on_font3_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f3 = ui->font3->text();
    ui->fontactive->setStyleSheet(COLOR_STYLE.arg(f3, variables.value("DefaultBackgroundColor"), f3));
}

void MainWindow::on_font4_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f4 = ui->font4->text();
    ui->fontdisabled->setStyleSheet(COLOR_STYLE.arg(f4, variables.value("DefaultBackgroundColor"), f4));
}

void MainWindow::on_font5_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f5 = ui->font5->text();
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
}

void MainWindow::on_font6_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f6 = ui->font6->text();
    ui->fontdisabled_2->setStyleSheet(COLOR_STYLE.arg(f6, variables.value("DefaultBackgroundColor"), f6));
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
}

void MainWindow::on_font7_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f7 = ui->font7->text();
    ui->fontbutton->setStyleSheet(COLOR_STYLE.arg(f7, variables.value("DefaultBackgroundColor"), f7));
}

void MainWindow::on_font8_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f8 = ui->font8->text();
    ui->fontbuttonpressed->setStyleSheet(COLOR_STYLE.arg(f8, variables.value("DefaultBackgroundColor"), f8));
}

void MainWindow::on_actionChange_backgrounds_triggered()
{
    newWin = new backgrounds(this);
    newWin->setAttribute(Qt::WA_Maemo5StackedWindow);
    newWin->setAttribute(Qt::WA_DeleteOnClose);

    newWin->show();
}

void MainWindow::on_pushButton_3_clicked()
{
    SaveWin = new savepreset(this);
    connect(SaveWin->ui->Save, SIGNAL(clicked()), this, SLOT(savedone()));
    SaveWin->show();
}

void MainWindow::savedone()
{
    QString presetname = SaveWin->ui->FileName->text();
    presetname.remove(QChar('\"'));
    presetname.remove(QChar(' '));
    presetname.simplified();
    QFile file("/opt/theme-customizer/presets/" + presetname);
    if (presetname.isEmpty()) {

        QMaemo5InformationBox::information(this, tr("You must give name for the preset."), QMaemo5InformationBox::DefaultTimeout);

    } else if (file.exists()) {
        QMessageBox msgBox;
        msgBox.setWindowTitle(tr("Overwrite color preset?"));
        msgBox.setText(tr("Color preset with this name already exists, do you want to overwrite it?"));
        msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        msgBox.setDefaultButton(QMessageBox::Yes);
        msgBox.button(msgBox.Yes)->setText(tr("Yes"));
        msgBox.button(msgBox.No)->setText(tr("No"));
        int ret = msgBox.exec();

        if ( ret == QMessageBox::Yes ) {

            if (file.exists()) file.remove();
            file.open(QIODevice::WriteOnly | QIODevice::Text);
            QTextStream out(&file);
            out << "DefaultTextColor=" << f1 << "\n" << "SecondaryTextColor=" << f2 << "\n" << "ActiveTextColor=" << f3 << "\n" << "DisabledTextColor=" << f4 << "\n" << "PaintedTextColor=" << f5 << "\n" << "SelectionColor=" << f6 << "\n" << "ButtonTextColor=" << f7 << "\n" << "ButtonTextPressedColor=" << f8 << "\n";

            // optional, as QFile destructor will already do it:
            file.close();
            SaveWin->hide();
            QMaemo5InformationBox::information(this, tr("Preset saved!"), QMaemo5InformationBox::DefaultTimeout);

        }
    } else {
        file.open(QIODevice::WriteOnly | QIODevice::Text);
        QTextStream out(&file);
        out << "DefaultTextColor=" << f1 << "\n" << "SecondaryTextColor=" << f2 << "\n" << "ActiveTextColor=" << f3 << "\n" << "DisabledTextColor=" << f4 << "\n" << "PaintedTextColor=" << f5 << "\n" << "SelectionColor=" << f6 << "\n" << "ButtonTextColor=" << f7 << "\n" << "ButtonTextPressedColor=" << f8 << "\n";

        // optional, as QFile destructor will already do it:
        file.close();
        SaveWin->hide();
        QMaemo5InformationBox::information(this, tr("Preset saved!"), QMaemo5InformationBox::DefaultTimeout);
    }
}

void MainWindow::on_pushButton_4_clicked()
{
    ManWin = new managepresets(this);
  //  connect(ManWin->ui->presetslist, SIGNAL(currentIndexChanged(int)), this, SLOT(on_presetslist_currentIndexChanged(int)));
    connect(ManWin->ui->loadbutton, SIGNAL(clicked()), this, SLOT(loadclicked()));
    connect(ManWin->ui->delbutton, SIGNAL(clicked()), this, SLOT(delclicked()));
    ManWin->show();
}

void MainWindow::loadclicked()
{
    if (ManWin->ui->presetslist->currentRow() == 0) {
        loadpr = "/etc/hildon/theme/colors.config";
    } else if (ManWin->ui->presetslist->currentRow() == 1) {
        QString colorfile = QFileInfo("/etc/hildon/theme/colors.config").canonicalFilePath();
        QString originalcolorfile = "/opt/theme-customizer/backups/" + colorfile;
        if (QFile(originalcolorfile).exists()) {
            loadpr = originalcolorfile;
        } else {
            loadpr = "/etc/hildon/theme/colors.config";
        }
    } else {
    loadpr = "/opt/theme-customizer/presets/" + ManWin->ui->presetslist->currentItem()->text();
    }
    oldfonts(loadpr);
    ManWin->hide();
    QMaemo5InformationBox::information(this, tr("Preset loaded."), QMaemo5InformationBox::DefaultTimeout);
}

void MainWindow::delclicked()
{
 //   ManWin->hide();
    QFile file("/opt/theme-customizer/presets/" + ManWin->ui->presetslist->currentItem()->text());
    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("Delete color preset?"));
    msgBox.setText(tr("Are you sure you want to delete this preset?"));
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    msgBox.setDefaultButton(QMessageBox::Yes);
    msgBox.button(msgBox.Yes)->setText(tr("Yes"));
    msgBox.button(msgBox.No)->setText(tr("No"));
    ManWin->destroy();
    int ret = msgBox.exec();

    if ( ret == QMessageBox::Yes ) {

        if (file.exists()) file.remove();
        ManWin = new managepresets(this);
        connect(ManWin->ui->loadbutton, SIGNAL(clicked()), this, SLOT(loadclicked()));
        connect(ManWin->ui->delbutton, SIGNAL(clicked()), this, SLOT(delclicked()));
        ManWin->show();
        QMaemo5InformationBox::information(this, tr("Preset deleted."), QMaemo5InformationBox::DefaultTimeout);

    }
}

void MainWindow::on_actionRestore_theme_files_triggered()
{
    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("Theme Customizer - restore files"));
    msgBox.setText(tr("Do you want to restore all original theme files?"));
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    msgBox.setDefaultButton(QMessageBox::Yes);
    msgBox.button(msgBox.Yes)->setText(tr("Yes"));
    msgBox.button(msgBox.No)->setText(tr("No"));
    int ret = msgBox.exec();

    if ( ret == QMessageBox::Yes ) {

        QString varattu2;
        varattu2 = tr("Restoring files from backup");
        progress4.setWindowModality(Qt::WindowModal);
        progress4.setWindowTitle(varattu2);
        progress4.setCancelButton(0);
        QStringList arguments2;
        arguments2 << "restorefilespushed";
        QProcess *process4 = new QProcess(this);
        connect(process4, SIGNAL(finished(int)), this, SLOT(process2Finished2(int)));
        process4->start("/sbin/launchcustomizer", arguments2);
        progress4.show();

    }
}

void MainWindow::process2Finished2(int)
{
 //   system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:'Restarting services, your screen will blink! After all is done, rebooting the device is recommended to reload all new values' uint32:0 string:'OK'");
 //   system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Restarting hildon-home...'");
    QMaemo5InformationBox::information(this, tr("Restarting services, your screen will blink! Rebooting the device is recommended to reload all new values."), QMaemo5InformationBox::DefaultTimeout);
    system("run-standalone.sh /usr/sbin/dsmetool -k /usr/bin/hildon-home");
    sleep(2);
    system("killall hildon-status-menu");
    sleep(2);
    system("killall osso-abook-home-applet");
    sleep(2);
    system("killall systemui");
    progress.setValue(99);
    sleep(2);
    system("run-standalone.sh /usr/sbin/dsmetool -t /usr/bin/hildon-home");
    sleep(4);
    system("killall hildon-desktop");
    sleep(2);
    system("killall theme-customizer");
}

void MainWindow::on_actionSave_as_new_theme_triggered()
{
    ThemeWin = new savenewtheme(this);
    connect(ThemeWin->ui->Save, SIGNAL(clicked()), this, SLOT(savetheme()));
    ThemeWin->show();
}

void MainWindow::savetheme()
{
    themename = ThemeWin->ui->FileName->text();
    themedir = themename;
    themedir = themedir.remove(QChar('\"'));
    themedir = themedir.remove(QChar(' '));
    themedir = themedir.simplified();
    themedir = themedir.toLower();
    QDir file;
    file = "/opt/usr/share/themes/" + themedir;

    if (themename.isEmpty()) {

        QMaemo5InformationBox::information(this, tr("You must give name for the theme."), QMaemo5InformationBox::DefaultTimeout);

    } else if (file.exists()) {

        if (QFile::exists("/opt/usr/share/themes/" + themedir + "/createdbythemecustomizer")) {
            QMessageBox msgBox;
            msgBox.setWindowTitle(tr("Overwrite existing theme?"));
            msgBox.setText(tr("Theme with this name already exists, do you want to overwrite it?"));
            msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
            msgBox.setDefaultButton(QMessageBox::Yes);
            msgBox.button(msgBox.Yes)->setText(tr("Yes"));
            msgBox.button(msgBox.No)->setText(tr("No"));
            int ret = msgBox.exec();

            if ( ret == QMessageBox::Yes ) {

                ThemeWin->hide();
                saveasnew = "1";
                runscript("saveonly");

            }

        } else {

            QMaemo5InformationBox::information(this, tr("Theme ") + themedir + tr(" already exists and cannot be overwritten!"), QMaemo5InformationBox::DefaultTimeout);

        }

    } else {
        ThemeWin->hide();
        saveasnew = "1";
        runscript("saveonly");
    }
}

void MainWindow::on_actionDelete_saved_themes_triggered()
{
    ManThemeWin = new managethemes(this);
    connect(ManThemeWin->ui->deletebutton, SIGNAL(clicked()), this, SLOT(deletetheme()));
    ManThemeWin->show();
}

void MainWindow::deletetheme()
{
    QString themetodelete = ManThemeWin->ui->themelist->currentItem()->text();
    QString check1 = QFileInfo("/opt/usr/share/themes/" + themetodelete + "/createdbythemecustomizer").canonicalFilePath();
    QString check2 = QFileInfo("/etc/hildon/theme/createdbythemecustomizer").canonicalFilePath();
    if ( check1 == check2 ) {
        QMaemo5InformationBox::information(this, tr("Selected theme is currently in use!") + "<br><br>" + tr("You can't delete a theme that's currently active."), QMaemo5InformationBox::NoTimeout);
        return;
    }
    QMessageBox msgBox;
    QStringList systemcommand;
    systemcommand << "deletethemepushed" << themetodelete;
    msgBox.setWindowTitle(tr("Delete theme?"));
    msgBox.setText(tr("Are you sure you want to delete this theme?"));
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    msgBox.setDefaultButton(QMessageBox::Yes);
    msgBox.button(msgBox.Yes)->setText(tr("Yes"));
    msgBox.button(msgBox.No)->setText(tr("No"));
    ManThemeWin->destroy();
    int ret = msgBox.exec();

    if ( ret == QMessageBox::Yes ) {
        QProcess *muoks0 = new QProcess(this);
        muoks0->start("/sbin/launchcustomizer", systemcommand);
        muoks0->waitForFinished();
        QMaemo5InformationBox::information(this, tr("Theme deleted."), QMaemo5InformationBox::DefaultTimeout);
        ManThemeWin = new managethemes(this);
        connect(ManThemeWin->ui->deletebutton, SIGNAL(clicked()), this, SLOT(deletetheme()));
        ManThemeWin->show();

    }
}

void MainWindow::on_actionExport_theme_triggered()
{
 //   QMaemo5InformationBox::information(this, tr("Select target folder where theme should be exported to"), QMaemo5InformationBox::DefaultTimeout);
    QString fontdir = QFileDialog::getSaveFileName(this, "Export theme", "/home/user/MyDocs", "Archives (*.tgz)");
    if (fontdir.isEmpty()) return;

    QString varattu2;
    varattu2 = tr("Exporting theme");
    progress2.setLabelText(varattu2);
    progress2.setWindowModality(Qt::WindowModal);
    progress2.setWindowTitle(varattu2);
    progress2.setCancelButton(0);
    QStringList arguments2;
    arguments2 << "exporttheme" << fontdir;
    QProcess *process2 = new QProcess(this);
    connect(process2, SIGNAL(finished(int)), this, SLOT(process2Finished(int)));
    process2->start("/sbin/launchcustomizer", arguments2);
    progress2.show();
}

void MainWindow::on_actionImport_theme_triggered()
{
    QMaemo5InformationBox::information(this, tr("Select .tgz file to import"), QMaemo5InformationBox::DefaultTimeout);
    QString fontdir = QFileDialog::getOpenFileName(this, "Import theme", "/home/user/MyDocs", "Archives (*.tgz)");
    if (fontdir.isEmpty()) return;

    QString varattu2;
    varattu2 = tr("Importing theme");
    progress2.setLabelText(varattu2);
    progress2.setWindowModality(Qt::WindowModal);
    progress2.setWindowTitle(varattu2);
    progress2.setCancelButton(0);
    QStringList arguments2;
    arguments2 << "importtheme" << fontdir;
    QProcess *process2 = new QProcess(this);
    connect(process2, SIGNAL(finished(int)), this, SLOT(process2Finished(int)));
    process2->start("/sbin/launchcustomizer", arguments2);
    progress2.show();
}
