#ifndef MAINWINDOW_H
#define MAINWINDOW_H
#include <QtCore>
#include <QMainWindow>
#include <QProgressDialog>
#include <QColorDialog>
#include <QHash>
#include <QFile>
#include <QTextStream>
#include <qwaitcondition.h>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    QProgressDialog progress;
    QColorDialog colors;
    void readdirs();
    void oldfonts();
    QStringList fonts;
    QHash<QString, QString> variables;
    void readSettings();
    void writeSettings();

private slots:
    void on_Snap_editingFinished();
    void on_horizontalSlider_3_valueChanged(int value);
    void on_checkBoxActivate_stateChanged(int );
    void on_lineEdit_2_editingFinished();
    void on_lineEdit_editingFinished();
    void on_horizontalSlider_2_valueChanged(int value);
    void on_fontdisabled_clicked();
    void on_fontactive_clicked();
    void on_fontsecondary_clicked();
    void on_fontprimary_clicked();
    void on_horizontalSlider_valueChanged(int);
    void on_pushButton_clicked();
    void processFinished(int exitCode);
};

#endif // MAINWINDOW_H
