#include "mutebutton.h"

Mutebutton::Mutebutton() :
        soundon_(QPixmap(":/gfx/soundon.png", "PNG")),
        soundoff_(QPixmap(":/gfx/soundoff.png", "PNG"))
{
    pix_ = soundon_;
}

QRectF Mutebutton::boundingRect() const
{
        return QRectF(0,0,pix_.width(),pix_.height());
}

void Mutebutton::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    painter->drawPixmap(0, 0, pix_);
}

void Mutebutton::toggle(bool mute) {
    if ( mute ) {
        pix_ = soundoff_;
    }
    else {
        pix_ = soundon_;
    }
}
