#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtGlobal>
#include <QTime>
//#ifdef Q_WS_MAEMO_5
#include <QtDBus>
//#endif

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    view_(new MyGfxView),
    hero_(new Hero),
    energybar_(new Energybar),
    scr_ones_(new Number),
    scr_tens_(new Number),
    scr_hunds_(new Number),
    goscr_ones_(new Number),
    goscr_tens_(new Number),
    goscr_hunds_(new Number),
    hiscr_ones_(new Number),
    hiscr_tens_(new Number),
    hiscr_hunds_(new Number),
    exitprompt_(new ExitPrompt),
    pausedscreen_(new PausedScreen),
    gameoverscreen_(new GameOverScreen),
    titlescreen_(new TitleScreen),
    mutebutton_(new Mutebutton),
    state_(RUNNING),
    score_(0),
    shotlimiter_(false),
    TIMERINTERVAL(80),
    DUCKINTERVAL(4000),
    SHOTLIMITINTERVAL(500),
    DUCKPOOINTERVAL(3456),
    poohits_(0)
{
    ui->setupUi(this);

    // Create seed for the random
    QTime time = QTime::currentTime();
    qsrand((uint)time.msec());

    view_->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    view_->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    this->setCentralWidget(view_);

    if ( view_ ) {
        connect(view_, SIGNAL(closeClicked()), this, SLOT(onCloseClick()));
        connect(view_, SIGNAL(dasboardClicked()), this, SLOT(onDashboardClick()));
        connect(view_, SIGNAL(quitNoClicked()), this, SLOT(onResume()));
        connect(view_, SIGNAL(quitYesClicked()), this, SLOT(close()));
        connect(view_, SIGNAL(resumeClicked()), this, SLOT(onResume()));
        connect(view_, SIGNAL(shoot(int,int)), this, SLOT(onShoot(int,int)));
        connect(view_, SIGNAL(muteClicked()), this, SLOT(onMute()));
    }

    // Load sounds
    sfx_shot_ = Mix_LoadWAV("/opt/thembloodyducks/shot.wav");
    sfx_duckhit_ = Mix_LoadWAV("/opt/thembloodyducks/duck.wav");
    sfx_duckpoo_ = Mix_LoadWAV("/opt/thembloodyducks/duckpoo.wav");
    sfx_poohit_ = Mix_LoadWAV("/opt/thembloodyducks/poohit.wav");
    sfx_gameover_ = Mix_LoadWAV("/opt/thembloodyducks/gameover.wav");
    sfx_title_ = Mix_LoadWAV("/opt/thembloodyducks/title.wav");

    // Accsensor
    acc_ = AccSensor::New();

    // Timers
    timer_ = new QTimer(this);
    connect(timer_, SIGNAL(timeout()), this, SLOT(onTimer()));
    ducktimer_ = new QTimer(this);
    connect(ducktimer_, SIGNAL(timeout()), this, SLOT(onDuckTimer()));
    duckpootimer_ = new QTimer(this);
    connect(duckpootimer_, SIGNAL(timeout()), this, SLOT(onDuckpooTimer()));
    shotlimittimer_ = new QTimer(this);
    connect(shotlimittimer_, SIGNAL(timeout()), this, SLOT(onShotLimitTimer()));

    // Settings
    loadSettings();

//#ifdef Q_WS_MAEMO_5
    this->showFullScreen();
//#endif

    firstgame();

    showTitlescreen();

}

MainWindow::~MainWindow()
{
    saveSettings();

    Mix_FreeChunk(sfx_duckhit_);
    Mix_FreeChunk(sfx_duckpoo_);
    Mix_FreeChunk(sfx_gameover_);
    Mix_FreeChunk(sfx_poohit_);
    Mix_FreeChunk(sfx_shot_);
    Mix_FreeChunk(sfx_title_);
    Mix_CloseAudio();
    SDL_Quit();

    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

int MainWindow::randInt(int min, int max) {
    if ( max < min ) return 0;
    return qrand() % ((max + 1) - min) + min;
}

void MainWindow::showTitlescreen() {
    changeState(TITLE);
    if ( !mute_ ) {
        Mix_PlayChannel(-1, sfx_title_, 0);
    }
    view_->scene()->addItem(titlescreen_);
    titlescreen_->setPos(0,0);
}

void MainWindow::firstgame() {
    // Add some stuff to scene
    // - hero
    view_->scene()->addItem(hero_);
    // - energy bar
    view_->scene()->addItem(energybar_);
    // - score
    view_->scene()->addItem(scr_ones_);
    view_->scene()->addItem(scr_tens_);
    view_->scene()->addItem(scr_hunds_);
    scr_ones_->setPos(770,450);
    scr_tens_->setPos(752,450);
    scr_hunds_->setPos(734,450);
    mutebutton_->setPos(0,430);
    mutebutton_->toggle(mute_);
    view_->scene()->addItem(mutebutton_);
    //newgame();
}

bool MainWindow::newgame() {

    view_->bgLottery();

    // Hero to starting position
    hero_->setPos(20,270);
    //hero_->setY(270);
    poohits_ = 0;
    energybar_->setHits(0);
    view_->scene()->update(100,0,400,150);

    // Zero points
    score_ = 0;
    scr_ones_->setNum(0);
    scr_tens_->setNum(0);
    scr_hunds_->setNum(0);

    // Delete old ducks, poos and bullets
    foreach (Duck* tmp, ducks_) {
        if (tmp) {
            delete tmp;
            tmp = 0;
        }
    }
    ducks_.clear();
    foreach (Duckpoo* tmp, poos_) {
        if (tmp) {
            delete tmp;
            tmp = 0;
        }
    }
    poos_.clear();
    foreach (Bullet* tmp, bullets_) {
        if (tmp) {
            delete tmp;
            tmp = 0;
        }
    }
    bullets_.clear();

    // Start ducks
    DUCKINTERVAL = 4000;
    DUCKPOOINTERVAL = 3456;
    ducktimer_->start(DUCKINTERVAL);
    duckpootimer_->start(DUCKPOOINTERVAL);

    changeState(RUNNING);
    shotlimittimer_->stop();
    shotlimiter_ = false;
    onDuckTimer();

    return true;
}

void MainWindow::onCloseClick() {
    if ( state_ == GAMEOVER ) {
        this->close();
    }

    // Prompt "Quit? Yes/No"
    changeState(EXITPROMPT);

    //qDebug() << "QUIT? yes / no";

}

void MainWindow::onDashboardClick() {
    //qDebug() << "DASH";
    // Pause game and show dashboard
    if ( state_ == RUNNING ) {
        changeState(PAUSED);
    }
//#ifdef Q_WS_MAEMO_5
    QDBusConnection c = QDBusConnection::sessionBus();
    QDBusMessage m = QDBusMessage::createSignal("/", "com.nokia.hildon_desktop", "exit_app_view");
    c.send(m);
//#endif
}

void MainWindow::onResume() {
    if ( state_ == GAMEOVER || state_ == TITLE ) {
        newgame();
    }
//    else if ( state_ == TITLE ) {
//        firstgame();
//    }
    changeState(RUNNING);
}

// Running/paused/...
void MainWindow::changeState(Gamestate state) {
    if ( view_ ) {
        view_->setState(state);

        if ( state == EXITPROMPT ) {
            timer_->stop();
            ducktimer_->stop();
            duckpootimer_->stop();
            view_->scene()->addItem(exitprompt_);
        }
        else if ( state == PAUSED ) {
            timer_->stop();
            ducktimer_->stop();
            duckpootimer_->stop();
            view_->scene()->addItem(pausedscreen_);
        }
        else if ( state == GAMEOVER ) {
            timer_->stop();
            ducktimer_->stop();
            duckpootimer_->stop();

            // Show score + hiscore
            if ( score_ > hiscore_ ) hiscore_ = score_;
            goscr_ones_->setNum(scr_ones_->getNum());
            goscr_tens_->setNum(scr_tens_->getNum());
            goscr_hunds_->setNum(scr_hunds_->getNum());
            hiscr_ones_->setNum(hiscore_ % 10);
            hiscr_tens_->setNum((hiscore_ - 100*(hiscore_/100)) / 10);
            hiscr_hunds_->setNum(hiscore_ / 100);

            goscr_hunds_->setPos(420,255);
            //goscr_hunds_->setY(255);
            goscr_tens_->setPos(438,255);
            //goscr_tens_->setY(255);
            goscr_ones_->setPos(456,255);
            //goscr_ones_->setY(255);
            hiscr_hunds_->setPos(420,295);
            //hiscr_hunds_->setY(295);
            hiscr_tens_->setPos(438,295);
            //hiscr_tens_->setY(295);
            hiscr_ones_->setPos(456,295);
            //hiscr_ones_->setY(295);

            view_->scene()->addItem(gameoverscreen_);
            view_->scene()->addItem(goscr_ones_);
            view_->scene()->addItem(goscr_tens_);
            view_->scene()->addItem(goscr_hunds_);
            view_->scene()->addItem(hiscr_ones_);
            view_->scene()->addItem(hiscr_tens_);
            view_->scene()->addItem(hiscr_hunds_);

        }
        else if ( state == RUNNING ) {
            if ( state_ == PAUSED ) {
                view_->scene()->removeItem(pausedscreen_);
            }
            else if ( state_ == EXITPROMPT ) {
                view_->scene()->removeItem(exitprompt_);
            }
            else if ( state_ == TITLE ) {
                view_->scene()->removeItem(titlescreen_);
                //firstgame();
                //return;
            }
            else if ( state_ == GAMEOVER ) {
                view_->scene()->removeItem(gameoverscreen_);
                view_->scene()->removeItem(goscr_ones_);
                view_->scene()->removeItem(goscr_tens_);
                view_->scene()->removeItem(goscr_hunds_);
                view_->scene()->removeItem(hiscr_ones_);
                view_->scene()->removeItem(hiscr_tens_);
                view_->scene()->removeItem(hiscr_hunds_);
                timer_->start(TIMERINTERVAL);
                state_ = state;
                return; // other timers are started in newGame()
            }
            timer_->start(TIMERINTERVAL);
            ducktimer_->start(DUCKINTERVAL);
            duckpootimer_->start(DUCKPOOINTERVAL);
        }

    }
    state_ = state;
}

//
// This is where the magic is done
//
void MainWindow::onTimer() {
    moveHero();
    moveDucks();
    moveBullets();
    movePoos();
}

//
// Hero movement
//
void MainWindow::moveHero() {
    // Previous position of the hero
    static qreal previousx = hero_->x();
    qreal tmpx = hero_->x();

    int rot = acc_->getX();
    qreal tiltRot = -1 * (rot) / 180.0;

    qreal dx = tiltRot * 6;
    if (  dx < 2 && dx > -2 ) {
        hero_->stop();
        hero_->animate();
    }
    else {
        qreal newx = hero_->x() + dx;

        if (hero_->x() > 710)
            newx = 710;

        if (hero_->x() < 0)
            newx = 0;

        hero_->setPos(newx, hero_->y());

        if ( hero_->x() > previousx ) {
            hero_->setDirection(0);
        }
        else {
            hero_->setDirection(1);
        }
        hero_->animate();
    }
    previousx = tmpx;
}

//
// Duck movement
//
void MainWindow::moveDucks() {
    for (int i = 0 ; i < ducks_.count(); ++i) {
        Duck* tmpduck = ducks_.at(i);
        if ( tmpduck->isDead()) {
            tmpduck->setPos(tmpduck->x(),tmpduck->y() + tmpduck->yspeed_);
            tmpduck->yspeed_ *= 1.5;
            if ( tmpduck->y() > 480 ) {
                view_->scene()->removeItem(tmpduck);
                delete tmpduck;
                ducks_.remove(i);
            }
            continue;
        }
        else {
            qreal newx;
            if ( tmpduck->getDirection() ) {
                newx = (tmpduck->x() - tmpduck->getSpeed());
                if ( tmpduck->x() < -100 ) tmpduck->setDirection(0);
            }
            else {
                newx = (tmpduck->x() + tmpduck->getSpeed());
                if ( tmpduck->x() > 800 ) tmpduck->setDirection(1);
            }
            qreal newy = ( tmpduck->getBaseY() + (24/tmpduck->getSpeed())*sin(tmpduck->x()) );
            tmpduck->setPos(newx, newy);
            tmpduck->animate();
        }
    }
}

//
// Bullet movement
//
void MainWindow::moveBullets() {
    for (int i = 0 ; i < bullets_.count(); ++i) {
        Bullet* tmpbullet = bullets_.at(i);
        qreal newx;
        if (tmpbullet->direction_) {
            newx = (tmpbullet->x() - 10);
        }
        else {
            newx = (tmpbullet->x() + 10);
        }
        tmpbullet->setPos(newx, tmpbullet->y() - 10);

        // Out of screen?
        if (tmpbullet->y() <= -10) {
            view_->scene()->removeItem(tmpbullet);
            delete tmpbullet;
            bullets_.remove(i);
        }
        // Hits a living duck?
        else {
            foreach (Duck* tmpduck, ducks_) {
                if (tmpduck->isDead()) {
                    continue;
                }
                qreal minx = tmpduck->x();
                qreal maxx = tmpduck->x() + tmpduck->boundingRect().width() - 8;
                qreal miny = tmpduck->y();
                qreal maxy = tmpduck->y() + tmpduck->boundingRect().height() - 8;

                if ((tmpbullet->x() > minx && tmpbullet->x() < maxx && tmpbullet->y() > miny && tmpbullet->y() < maxy)) {
                    //qDebug() << "HIT!";
                    tmpduck->kill();
                    if ( !mute_ ) {
                        Mix_PlayChannel(-1, sfx_duckhit_, 0);
                    }
                    view_->scene()->removeItem(tmpbullet);
                    delete tmpbullet;
                    bullets_.remove(i);
                    int tmp = score_ / 10;
                    score_++;
                    if ( tmp != score_ / 10 ) {
                        DUCKINTERVAL *= 0.85;
                        DUCKPOOINTERVAL *= 0.85;
                        if ( DUCKINTERVAL < 600 ) DUCKINTERVAL = 600;
                        if ( DUCKPOOINTERVAL < 400 ) DUCKPOOINTERVAL = 400;
                        ducktimer_->stop();
                        duckpootimer_->stop();
                        ducktimer_->start(DUCKINTERVAL);
                        duckpootimer_->start(DUCKPOOINTERVAL);
                    }
                    if ( score_ >= 999 ) {
                        score_ = 999;

                        // Game over ;D
                        if ( !mute_ ) {
                            Mix_PlayChannel(-1, sfx_gameover_, 0);
                        }
                        changeState(GAMEOVER);
                        return;
                    }
                    else {
                        scr_ones_->setNum(score_ % 10);
                        scr_hunds_->setNum(score_ / 100);
                        scr_tens_->setNum( (score_ - 100 * (score_/100) ) / 10 );
                        view_->scene()->update(700,440,100,60);
                    }
                    break;
                }
            }
        }
    }

}

//
// Duckpoo movement
//
void MainWindow::movePoos() {
    for (int i = 0; i < poos_.count(); ++i) {
        Duckpoo* tmppoo = poos_.at(i);
        tmppoo->setPos(tmppoo->x(),tmppoo->y() + tmppoo->yspeed_);
        tmppoo->yspeed_ *= 1.2;
        // out of screen?
        if ( tmppoo->y() > 480 || tmppoo->x() < 0 || tmppoo->x() > 800) {
            view_->scene()->removeItem(tmppoo);
            delete tmppoo;
            poos_.remove(i);
            continue;
        }

        if ( tmppoo->direction_ ) {
            tmppoo->setPos(tmppoo->x() - tmppoo->xspeed_, tmppoo->y());
        }
        else {
            tmppoo->setPos(tmppoo->x() + tmppoo->xspeed_, tmppoo->y());
        }

        // Does it hit our hero?
        qreal minx = hero_->x() + 10;
        qreal maxx = hero_->x() + hero_->boundingRect().width() - 10;
        qreal miny = hero_->y() + 4;
        qreal maxy = hero_->y() + hero_->boundingRect().height() - 20;

        if ( tmppoo->x() > minx && tmppoo->x() < maxx && tmppoo->y() > miny && tmppoo->y() < maxy ) {
            //qDebug() << "POO HIT!";
            view_->scene()->removeItem(tmppoo);
            delete tmppoo;
            poos_.remove(i);
            poohits_++;
            energybar_->setHits(poohits_);
            view_->scene()->update(100,0,400,150);
            if ( poohits_ >= 5 ) {
                // GAME OVER!!!
                if ( !mute_ ) {
                    Mix_PlayChannel(-1, sfx_gameover_, 0);
                }
                changeState(GAMEOVER);
                break;
            }
            if ( !mute_ ) {
                Mix_PlayChannel(-1, sfx_poohit_, 0);
            }
            continue;
        }

    }
}

//
// Duck generator
//
void MainWindow::onDuckTimer() {

    // max 10 ducks at a time
    if ( ducks_.count() > 9 ) {
        return;
    }

    Duck* tmpduck = new Duck();
    ducks_.append(tmpduck);

    // random
    // - Base Y
    // - speed
    // - left or right
    tmpduck->setSpeed(randInt(5,12));
    tmpduck->setDirection(randInt(0,1));
    tmpduck->setBaseY(randInt(70,180));

    if (tmpduck->getDirection()) {
        tmpduck->setPos(800, tmpduck->getBaseY());
    }
    else {
        tmpduck->setPos(-100,tmpduck->getBaseY());
    }

    //tmpduck->setY(tmpduck->getBaseY());

    view_->scene()->addItem(tmpduck);
}

//
// Shooting
//
void MainWindow::onShoot(int x, int y) {
    if ( !shotlimiter_ ) {
        Bullet* tmpbullet = new Bullet;

//        if ( x < 1000 &&
//             ((x > hero_->x() && hero_->getDirection()) ||
//             (x < hero_->x() && hero_->getDirection() == 0 )) ) {
//            return;
//        }

        tmpbullet->direction_ = hero_->getDirection();
        qreal newy = (hero_->y()+25);
        if ( hero_->getDirection() ) {
            tmpbullet->setPos(hero_->x(), newy);
        }
        else {
            tmpbullet->setPos(hero_->x()+hero_->boundingRect().width(), newy);
        }
        bullets_.append(tmpbullet);
        view_->scene()->addItem(tmpbullet);
        if ( !mute_ ) {
            Mix_PlayChannel(-1, sfx_shot_, 0);
        }
        shotlimiter_ = true;
        shotlimittimer_->start(SHOTLIMITINTERVAL);
    }
}

void MainWindow::onShotLimitTimer() {
    shotlimittimer_->stop();
    shotlimiter_ = false;
}

//
// Let's make a duck poo
//
void MainWindow::onDuckpooTimer() {
    // Random duck
    Duck* tmpduck = 0;
    if ( ducks_.count()) {
        tmpduck = ducks_.at(randInt(0, ducks_.count()-1));
        int i = 0;
        while ( i < ducks_.count() && (tmpduck->isDead() || tmpduck->x() < 30 || tmpduck->x() > 760) ) {
            tmpduck = ducks_.at(randInt(0, ducks_.count()-1));
            ++i;
        }
        if ( i == ducks_.count()) {
            return; // no valid poo ducks
        }
    }
    else {
        return; // no ducks at all
    }
    Duckpoo* newpoo = new Duckpoo;
    poos_.append(newpoo);
    newpoo->direction_ = tmpduck->getDirection();
    newpoo->pix_ = newpoo->poopixes_.at(newpoo->direction_);
    qreal newx = (tmpduck->x() + newpoo->direction_ * tmpduck->boundingRect().width());
    if ( newpoo->direction_ ) {
        newx -= 30;
    }
    else {
        newx += 30;
    }
    newpoo->setPos(newx, tmpduck->y() + 36);
    newpoo->xspeed_ = tmpduck->getSpeed();
    view_->scene()->addItem(newpoo);
    if ( !mute_ ) {
        Mix_PlayChannel(-1, sfx_duckpoo_, 0);
    }
}

//
// Settings
//
void MainWindow::saveSettings() const {
    // Hiscore and mute
    QSettings sett("thembloodyducks/config");
    sett.setValue("hiscore", hiscore_);
    sett.setValue("mute", mute_);
}
void MainWindow::loadSettings() {
    QSettings sett("thembloodyducks/config");
    bool bOK;
    mute_ = sett.value("mute", QVariant(false)).toBool();
    hiscore_ = sett.value("hiscore", QVariant(0)).toInt(&bOK);
}

// Mute
void MainWindow::onMute() {
    mute_ = !mute_;
    mutebutton_->toggle(mute_);
    view_->scene()->update(0,430,50,50);
}
