#include "hero.h"

Hero::Hero() :
        direction_(0),
        framecounter_(0)
{
    QPixmap tmp = QPixmap(":/gfx/r_ukkeli01.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/r_ukkeli02.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/r_ukkeli01.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/r_ukkeli03.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_ukkeli01.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_ukkeli02.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_ukkeli01.png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_ukkeli03.png", "PNG");
    pixes_.append(tmp);

    HEROFRAMES = pixes_.count() / 2;

    heropix_ = pixes_.at(0);
}

QRectF Hero::boundingRect() const
{
        return QRectF(0,0,heropix_.width(),heropix_.height());
}

void Hero::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    painter->drawPixmap(0, 0, heropix_);
}

// Direction set and get
void Hero::setDirection(int direction) {
    if ( direction == 0 || direction == 1 ) {
        direction_ = direction;
        //framecounter_ = 0;
    }
}

int Hero::getDirection() {
    return direction_;
}

// Animate
void Hero::animate() {
    heropix_ = pixes_.at(direction_*HEROFRAMES+framecounter_);
    framecounter_ = (framecounter_ + 1) % HEROFRAMES;
}

void Hero::stop() {
    heropix_ = pixes_.at(direction_*HEROFRAMES);
    framecounter_ = 0;
}
