#include "energybar.h"

Energybar::Energybar() :
        hits_(0)
{
    QPixmap tmp = QPixmap(":/gfx/energybar1.png", "PNG");
    barpixes_.append(tmp);
    tmp = QPixmap(":/gfx/energybar2.png", "PNG");
    barpixes_.append(tmp);
    tmp = QPixmap(":/gfx/energybar3.png", "PNG");
    barpixes_.append(tmp);
    tmp = QPixmap(":/gfx/energybar4.png", "PNG");
    barpixes_.append(tmp);
    tmp = QPixmap(":/gfx/energybar5.png", "PNG");
    barpixes_.append(tmp);
    tmp = QPixmap(":/gfx/energybar6.png", "PNG");
    barpixes_.append(tmp);

    pix_ = barpixes_.at(0);
}

QRectF Energybar::boundingRect() const
{
        return QRectF(0,0,pix_.width(),pix_.height());
}

void Energybar::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    painter->drawPixmap(0, 0, pix_);
}

void Energybar::setHits(int i) {
    if ( i < 0 || i > 5 ) {
        return; // error
    }
    hits_ = i;
    pix_ = barpixes_.at(i);
}

int Energybar::getHits() const {
    return hits_;
}
