#include "duck.h"

Duck::Duck() :
        yspeed_(8),
        direction_(0),
        framecounter_(0),
        dead_(false)
{
    int duckstyle = qrand() % 2;

    QPixmap tmp = QPixmap(":/gfx/r_duck01_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/r_duck02_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/r_duck01_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/r_duck03_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/r_duck04_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_duck01_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_duck02_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_duck01_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_duck03_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_duck04_" + QString::number(duckstyle)+ ".png", "PNG");
    pixes_.append(tmp);
    DUCKFRAMES = pixes_.count() / 2;

    tmp = QPixmap(":/gfx/r_duckdead_" + QString::number(duckstyle)+ ".png", "PNG");
    deadpixes_.append(tmp);
    tmp = QPixmap(":/gfx/l_duckdead_" + QString::number(duckstyle)+ ".png", "PNG");
    deadpixes_.append(tmp);

    duckpix_ = pixes_.at(0);
}

QRectF Duck::boundingRect() const
{
        return QRectF(0,0,duckpix_.width(),duckpix_.height());
}

void Duck::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    painter->drawPixmap(0, 0, duckpix_);
}

// Direction set and get
void Duck::setDirection(int direction) {
    if ( direction == 0 || direction == 1 ) {
        direction_ = direction;
    }
}

int Duck::getDirection() const {
    return direction_;
}

// Animate
void Duck::animate() {
    duckpix_ = pixes_.at(direction_*DUCKFRAMES+framecounter_);
    framecounter_ = (framecounter_ + 1) % DUCKFRAMES;
}

void Duck::setBaseY(int y) {
    basey_ = y;
}

int Duck::getBaseY() const {
    return basey_;
}

void Duck::setSpeed(int s) {
    speed_ = s;
}

int Duck::getSpeed() const {
    return speed_;
}

bool Duck::isDead() const {
    return dead_;
}

void Duck::kill() {
    dead_ = true;
    duckpix_ = deadpixes_.at(direction_);
}
