#include "mygfxview.h"

MyGfxView::MyGfxView(QWidget *parent) :
    QGraphicsView(parent),
    scene_(new QGraphicsScene),
    bgpix_(QPixmap(":/gfx/bg0.png", "PNG"))
{
    this->setGeometry(0,0,800,480);
    this->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    this->setScene(scene_);
    scene_->setSceneRect(QRectF(QPointF(0,0), this->size()));
    bgbrush_ = new QBrush(bgpix_);
    scene_->setBackgroundBrush(*bgbrush_);
}

void MyGfxView::bgLottery() {
    int bgcount = 4; // Number of bg images
    int bgnum = qrand() % bgcount;
    QString bgfile = ":/gfx/bg" + QString::number(bgnum) + ".png";
    bgpix_.load(bgfile, "PNG");
    if ( bgbrush_ ) delete bgbrush_;
    bgbrush_ = new QBrush(bgpix_);
    scene_->setBackgroundBrush(*bgbrush_);
}

// Mouse press
void MyGfxView::mousePressEvent(QMouseEvent *event) {
    int mx = event->x();
    int my = event->y();

    // Close button
    if ( (state_ == RUNNING || state_ == GAMEOVER) && mx > 725 && my < 65 ) {
        emit closeClicked();
    }
    // Mute button
    else if ( state_ == RUNNING && mx <= 46 && my >= 444 ) {
        emit muteClicked();
    }
    // Dashboard button
    else if ( mx < 65 && my < 65 ) {
        emit dasboardClicked();
    }
    else {
        if ( state_ == PAUSED ) {
            emit resumeClicked();
        }
        // Quit? Yes/No
        else if ( state_ == EXITPROMPT ) {
            // "Yes" button
            if ( mx > 297 && mx < 297+71 && my > 258 && my < 258+51 )
            {
                emit quitYesClicked();
            }
            // "No" button
            else if ( mx > 442 && mx < 442+77 && my > 252 && my < 252+52 ) {
                emit quitNoClicked();
            }
        }
        else if ( state_ == GAMEOVER ) {
            emit resumeClicked();
        }
        else if ( state_ == RUNNING ) {
            emit shoot(mx, my);
        }

    }
}

// Keyboard
void MyGfxView::keyPressEvent(QKeyEvent *event) {
    if ( state_ == RUNNING ) {
        if ( event->key() == Qt::Key_Space ) {
            emit shoot(1000, 1000);
        }
    }
}

void MyGfxView::setState(Gamestate state) {
    state_ = state;
}
