#ifndef DUCK_H
#define DUCK_H

#include <QGraphicsItem>
#include <QtGui>
#include <QVector>

class Duck : public QGraphicsItem
{
public:
    Duck();

    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

    void setDirection(int direction);
    int getDirection() const;

    void setBaseY(int y);
    int getBaseY() const;

    void setSpeed(int s);
    int getSpeed() const;

    bool isDead() const;
    void kill();

    void animate();

    int yspeed_; // dead duck's dropping speed

private:
    QPixmap duckpix_;

    QVector<QPixmap> pixes_;
    QVector<QPixmap> deadpixes_;
    int direction_; // 0 is right, 1 is left
    int framecounter_;
    int DUCKFRAMES;

    int speed_;
    int basey_;

    bool dead_;
};

#endif // DUCK_H
