#ifndef MYGFXVIEW_H
#define MYGFXVIEW_H

#include <QGraphicsView>
#include <QtGui>

#include "misc.h"

class MyGfxView : public QGraphicsView
{
Q_OBJECT
public:
    MyGfxView(QWidget *parent = 0);

    void setState(Gamestate state);
    void bgLottery();

signals:
    void closeClicked();
    void dasboardClicked();
    void resumeClicked();
    void quitYesClicked();
    void quitNoClicked();
    void shoot(int x, int y); // mouse coordinates
    void muteClicked();

public slots:

protected:
    void mousePressEvent(QMouseEvent * event);

private:
    QGraphicsScene *scene_;
    QPixmap bgpix_;
    QBrush *bgbrush_;

    Gamestate state_;
};

#endif // MYGFXVIEW_H
