#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include <QVector>

#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"

#include "misc.h"
#include "libmctacc.h"
#include "mygfxview.h"
#include "hero.h"
#include "energybar.h"
#include "mutebutton.h"
#include "duck.h"
#include "bullet.h"
#include "duckpoo.h"
#include "number.h"
#include "exitprompt.h"
#include "pausedscreen.h"
#include "gameoverscreen.h"

namespace Ui {
    class MainWindow;
}


class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    bool newgame();

    int randInt(int min, int max);

public slots:
    void onCloseClick();
    void onDashboardClick();
    void onResume();
    void onShoot(int x, int y);
    void onTimer();
    void onDuckTimer();
    void onDuckpooTimer();
    void onShotLimitTimer();
    void onMute();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;

    void changeState(Gamestate state);
    void moveHero();
    void moveDucks();
    void moveBullets();
    void movePoos();
    void saveSettings() const;
    void loadSettings();

    AccSensor* acc_;

    // Graphical thingies
    MyGfxView* view_;
    Hero* hero_;
    Energybar* energybar_;
    QVector<Duck*> ducks_;
    QVector<Bullet*> bullets_;
    QVector<Duckpoo*> poos_;
    ExitPrompt* exitprompt_;
    PausedScreen* pausedscreen_;
    GameOverScreen* gameoverscreen_;
    Mutebutton* mutebutton_;
    Number* scr_ones_;
    Number* scr_tens_;
    Number* scr_hunds_;
    Number* goscr_ones_;
    Number* goscr_tens_;
    Number* goscr_hunds_;
    Number* hiscr_ones_;
    Number* hiscr_tens_;
    Number* hiscr_hunds_;

    // Sounds
    Mix_Chunk* sfx_shot_;
    Mix_Chunk* sfx_duckhit_;
    Mix_Chunk* sfx_duckpoo_;
    Mix_Chunk* sfx_poohit_;
    Mix_Chunk* sfx_gameover_;

    Gamestate state_;
    int score_;
    int hiscore_;

    bool shotlimiter_;

    int TIMERINTERVAL;
    int DUCKINTERVAL;
    int SHOTLIMITINTERVAL;
    int DUCKPOOINTERVAL;

    QTimer* timer_;
    QTimer* ducktimer_;
    QTimer* shotlimittimer_;
    QTimer* duckpootimer_;

    int poohits_;

    bool mute_;

};

#endif // MAINWINDOW_H
