# -*- coding: utf-8 -*-
import os, sys, cPickle
from PyQt4 import QtGui, QtCore
from tfloptions_gui import *

class TflOptionsDisplay(QtGui.QMainWindow):
    def __init__(self, settings, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindowtflOptions()
        self.ui.setupUi(self)
        self.settings = settings
        
        param_list = self.parentWidget().tfl_params
        
        if( 'noSolidStairs' in param_list):
          self.ui.checkBoxNoStairs.setCheckState(QtCore.Qt.Checked)
        if( 'noEscalators' in param_list):
          self.ui.checkBoxNoEscalators.setCheckState(QtCore.Qt.Checked)
        if( 'noElevators' in param_list):
          self.ui.checkBoxNoLifts.setCheckState(QtCore.Qt.Checked)
        if( 'wheelchair' in param_list):
          self.ui.checkBoxUseWheelchair.setCheckState(QtCore.Qt.Checked)

        if( not 'inclMOT_0' in param_list):
          self.ui.checkBoxRail.setCheckState(QtCore.Qt.Unchecked)
        if( not 'inclMOT_1' in param_list):
          self.ui.checkBoxDLR.setCheckState(QtCore.Qt.Unchecked)
        if( not 'inclMOT_4' in param_list):
          self.ui.checkBoxTram.setCheckState(QtCore.Qt.Unchecked)
        if( not 'inclMOT_9' in param_list):
          self.ui.checkBoxRiver.setCheckState(QtCore.Qt.Unchecked)
        if( not 'inclMOT_2' in param_list):
          self.ui.checkBoxTube.setCheckState(QtCore.Qt.Unchecked)
        if( not 'inclMOT_5' in param_list):
          self.ui.checkBoxBus.setCheckState(QtCore.Qt.Unchecked)
        if( not 'inclMOT_7' in param_list):
          self.ui.checkBoxCoach.setCheckState(QtCore.Qt.Unchecked)

        
        QtCore.QObject.connect(self.ui.checkBoxNoStairs, QtCore.SIGNAL('stateChanged(int)'), self.doDisableStairs)
        QtCore.QObject.connect(self.ui.checkBoxNoEscalators, QtCore.SIGNAL('stateChanged(int)'), self.doDisableEsc)
        QtCore.QObject.connect(self.ui.checkBoxNoLifts, QtCore.SIGNAL('stateChanged(int)'), self.doDisableLifts)
        QtCore.QObject.connect(self.ui.checkBoxUseWheelchair, QtCore.SIGNAL('stateChanged(int)'), self.doEnableWheelChair)
        
        QtCore.QObject.connect(self.ui.checkBoxRail, QtCore.SIGNAL('stateChanged(int)'), self.doRail)
        QtCore.QObject.connect(self.ui.checkBoxDLR, QtCore.SIGNAL('stateChanged(int)'), self.doDLR)
        QtCore.QObject.connect(self.ui.checkBoxTram, QtCore.SIGNAL('stateChanged(int)'), self.doTram)
        QtCore.QObject.connect(self.ui.checkBoxRiver, QtCore.SIGNAL('stateChanged(int)'), self.doRiver)
        QtCore.QObject.connect(self.ui.checkBoxTube, QtCore.SIGNAL('stateChanged(int)'), self.doTube)
        QtCore.QObject.connect(self.ui.checkBoxBus, QtCore.SIGNAL('stateChanged(int)'), self.doBus)
        QtCore.QObject.connect(self.ui.checkBoxCoach, QtCore.SIGNAL('stateChanged(int)'), self.doCoach)
        
        QtCore.QObject.connect(self.ui.pushButtonSave, QtCore.SIGNAL('clicked()'), self.saveOptions)
                
        
    def saveOptions(self):
      saveData = cPickle.dumps(self.parentWidget().tfl_params)
      self.settings.setValue("tfl_params", saveData )

    def doDisableStairs(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['noSolidStairs'] = 'on'
        else:
          del self.parentWidget().tfl_params['noSolidStairs']
    
    def doDisableEsc(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['noEscalators'] = 'on'
        else:
          del self.parentWidget().tfl_params['noEscalators']
    
    def doDisableLifts(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['noElevators'] = 'on'
        else:
          del self.parentWidget().tfl_params['noElevators']
    
    def doEnableWheelChair(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['wheelchair'] = 'on'
        else:
          del self.parentWidget().tfl_params['wheelchair']

# Start of transport types

    def doRail(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['inclMOT_0'] = 'on'
        else:
          del self.parentWidget().tfl_params['inclMOT_0']
    
    def doDLR(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['inclMOT_1'] = 'on'
        else:
          del self.parentWidget().tfl_params['inclMOT_1']
    
    def doTube(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['inclMOT_2'] = 'on'
        else:
          del self.parentWidget().tfl_params['inclMOT_2']
    
    def doTram(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['inclMOT_4'] = 'on'
        else:
          del self.parentWidget().tfl_params['inclMOT_4']
     
    def doBus(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['inclMOT_5'] = 'on'
        else:
          del self.parentWidget().tfl_params['inclMOT_5']
    
    def doCoach(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['inclMOT_7'] = 'on'
        else:
          del self.parentWidget().tfl_params['inclMOT_7']
    
    def doRiver(self, value):
        if(value == 2):
          self.parentWidget().tfl_params['inclMOT_9'] = 'on'
        else:
          del self.parentWidget().tfl_params['inclMOT_9']
