﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtGui, QtCore
from xml.dom import minidom
import urllib
import sys
from tubestatus import *
from tubemap import *
from tflapp_mainwindow import *
import location

CURRENTVERSION = "0.1.0"


PLANNER_URL_PART1 = "http://journeyplanner.tfl.gov.uk/user/XSLT_TRIP_REQUEST2?language=en&sessionID=0&requestID=0&ptOptionsActive=1&itOptionsActive=1&imparedOptionsActive=1&ptAdvancedOptions=1&advOptActive_2=1&advOpt_2=1&execInst=normal&command=&itdLPxx_request=&itdLPxx_view=&itdLPxx_tubeMap=&calculateDistance=1&name_origin="
PLANNER_URL_PART2 = "&nameState_origin=notidentified&nameDefaultText_origin=start&place_origin=London&type_origin=locator&name_destination="
PLANNER_URL_PART3 ="&nameState_destination=notidentified&nameDefaultText_destination=end&place_destination=London&type_destination=locator&itdTripDateTimeDepArr=dep&Submit=Search&routeType=LEASTTIME&name_via=Enter+location+(optional)&nameState_via=notidentified&nameDefaultText_via=Enter+location+(optional)&type_via=stop&place_via=London&placeDefaultText_via=London&includedMeans=checkbox&inclMOT_11=1&inclMOT_0=on&inclMOT_1=on&inclMOT_2=on&inclMOT_4=on&inclMOT_5=on&inclMOT_7=on&inclMOT_9=on&trITMOTvalue101=60&trITMOTvalue=20&trITMOT=100&changeSpeed=Fast"


class TflAppMain(QtGui.QMainWindow):
    def __init__(self, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)

        self.setup_settings()
        self.load_settings()

        self.tflstatus = TflStatus(self.settings, self)
        self.tubemap = TubeMapDisplay(self)
        self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
        self.tflstatus.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow )
        self.tubemap.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow )



        QtCore.QObject.connect(self.ui.pushButtonOpenStatus, QtCore.SIGNAL('clicked()'), self.doOpenStatusWindow)
        QtCore.QObject.connect(self.ui.pushButtonNavHome, QtCore.SIGNAL('clicked()'), self.doGetmeHome)
        QtCore.QObject.connect(self.ui.pushButtonTubeMap, QtCore.SIGNAL('clicked()'), self.showTubeMap)
        QtCore.QObject.connect(self.ui.lineEditHomePC, QtCore.SIGNAL('returnPressed()'), self.saveHome)
        QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.showAbout)


    def setup_settings(self):
        settings = QtCore.QSettings()
        QtCore.QCoreApplication.setOrganizationName('gman.me.uk')
        QtCore.QCoreApplication.setOrganizationDomain('gman.me.uk')
        QtCore.QCoreApplication.setApplicationName('Tfl App')
        self.settings = settings

    def load_settings(self):
        try:
            # load the save file into a temp dict
            self.dest = self.settings.value("home_Pcode").toString()
        except:
            print "firstRun... no Savefile found"
            
        if(self.dest == ""):
            self.dest = "EC1R4TN" #Sadlers Wells

        self.ui.lineEditHomePC.setText(self.dest)

    def doOpenStatusWindow(self):
        self.tflstatus.show()
        self.tflstatus.showFullScreen()

        # Just get the UI to display before we start churning
        QtCore.QTimer.singleShot(0, self.tflstatus, QtCore.SLOT('doStuff()'));
        

    def doGetmeHome(self):
        currentLoc = self.getCurrentPCode()
        self.dest = self.ui.lineEditHomePC.text()
        print "start: " + currentLoc +  "& dest:" + self.dest
        finalUrl = PLANNER_URL_PART1 + currentLoc + PLANNER_URL_PART2 + self.dest + PLANNER_URL_PART3
        QtGui.QDesktopServices.openUrl(QtCore.QUrl(finalUrl, QtCore.QUrl.TolerantMode))

    def getCurrentPCode(self):
        self.getCurrentLoc()
        if( (51.286829 <= self.curLocLat <= 51.69232322) and (-0.510350 <= self.curLocLong <= 0.334030) ):
            pCode = self.getCurrentPCodeFromLoc()
        else:
            os.popen('dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Does not work outside London - Just a test route for you"')
            pCode = "NW1 2DB" #british library
        
        return pCode

    def getCurrentLoc(self):
        control = location.GPSDControl.get_default()
        device = location.GPSDevice()
        control.set_properties(preferred_method=location.METHOD_ACWP,
                       preferred_interval=location.INTERVAL_DEFAULT)


        self.loop = gobject.MainLoop()
        control.connect("error-verbose", self.on_error, self.loop)
        device.connect("changed", self.on_changed, control)
        control.connect("gpsd-stopped", self.on_stop, self.loop)
        gobject.idle_add(self.start_location, control)

        self.loop.run()


    def getCurrentPCodeFromLoc(self):
        openConn = ConnMan()
        openConn.startConnMan()

        url = "http://www.uk-postcodes.com/latlng/" + str(self.curLocLat) + "," + str(self.curLocLong) + ".xml"

        response = minidom.parse(urllib.urlopen(url))
        postcodeNode = response.getElementsByTagName('postcode')
        print "xml parsed response" + str(postcodeNode[0].firstChild.data)

        return str(postcodeNode[0].firstChild.data)

    def showTubeMap(self):
        self.tubemap.setupWindow()
        self.tubemap.show()
        return

    def saveHome(self):
        print "saving settings"
        self.settings.setValue("home_Pcode", self.ui.lineEditHomePC.text() )


    def showAbout(self):
        aboutString = "Tfl App: v" + CURRENTVERSION + "\nGirish Gopi (maemo@gman.me.uk)\nMany thanks to all of t.m.o (& w.m.o) and the gaffa"
        QtGui.QMessageBox.information(self, "About Tfl App", aboutString)

    def on_error(self, control, error, data):
        print "location error: %d... quitting" % error
        data.quit()

    def on_changed(self, device, data):
        print "changed:"
        if not device:
            return
        if device.fix:
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                print "lat = %f, long = %f" % device.fix[4:6]
                self.curLocLat = device.fix[4]
                self.curLocLong = device.fix[5]
                data.stop()

    def on_stop(self, control, data):
        print "quitting"
        data.quit()

    def start_location(self, data):
        data.start()
        return False

if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    
    tflapp = TflAppMain()
    tflapp.show()
    
    sys.exit(app.exec_())
