# Tethering Status Plugin for Maemo 5
#
# Copyright (c) 2010 by Philip Langdale
#
# GNU General Public Licence (GPL)
# 
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA  02111-1307  USA
#

from dbus import Interface
from dbus.mainloop.glib import DBusGMainLoop

import gtk
import dbus
import hildondesktop

class GprsStatusPlugin(hildondesktop.StatusMenuItem):

  gprs = None
  icd = None

  # attached == False    : Detached
  # attached == True     :
  #   available == True  : Attached
  #   available == False : Suspended
  available = False
  attached = False
  internal = False

  scan = None

  def __init__(self):
    hildondesktop.StatusMenuItem.__init__(self)

    bus = dbus.Bus.get_system(True)
    bus.set_exit_on_disconnect(False)

    proxy = bus.get_object('com.nokia.csd.GPRS', '/com/nokia/csd/gprs')
    self.gprs = Interface(proxy, 'com.nokia.csd.GPRS')
    props = Interface(proxy, 'org.freedesktop.DBus.Properties')

    proxy = bus.get_object('com.nokia.icd', '/com/nokia/icd')
    self.icd = Interface(proxy, 'com.nokia.icd')

    self.gprs.connect_to_signal("Attached", self.OnAttached)
    self.gprs.connect_to_signal("Detached", self.OnDetached)
    self.gprs.connect_to_signal("Suspended", self.OnSuspended)
    self.gprs.connect_to_signal("Available", self.OnAvailable)
    self.icd.connect_to_signal("status_changed", self.OnIcdStatus)
    self.attached = props.Get('com.nokia.csd.GPRS', "Attached")
    self.available = props.Get('com.nokia.csd.GPRS', "Available")

    proxy = bus.get_object('com.nokia.icd2', '/com/nokia/icd2')
    icd2 = Interface(proxy, 'com.nokia.icd2')
    self.scan = icd2.connect_to_signal("scan_result_sig", self.OnScanResult, byte_arrays=True, utf8_strings=True)
    icd2.scan_req(dbus.UInt32(1), dbus.Array([dbus.String("GPRS")]))

    self.UpdateState()

  def OnScanResult(self, *args):
    if args[7] != 'GPRS':
      return

    self.scan.remove()

    ipinfo = self.icd.get_ipinfo()
    id = str(args[10])
    length = len(id)
    length = length -1
    if str(ipinfo[0]) == id[0:length]:
       self.internal = True
       self.UpdateState()

  def UpdateState(self):
    pixbuf_name = ''

    if self.internal == True:
      pixbuf_name = 'statusarea_internetconn_packetdata_dimmed'
    elif self.attached == False:
      pixbuf_name = 'statusarea_internetconn_packetdata_dimmed'
    elif self.available == True:
      pixbuf_name = 'general_packetdata'
    else:
      pixbuf_name = 'general_packetdata_suspended'

    icon_theme = gtk.icon_theme_get_default()

    pixbuf = icon_theme.load_icon(pixbuf_name, 22, gtk.ICON_LOOKUP_NO_SVG)
    self.set_status_area_icon(pixbuf)

  def OnAttached(self, state):
    self.attached = True
    self.UpdateState()

  def OnDetached(self):
    self.attached = False
    self.UpdateState()

  def OnSuspended(self, code, state):
    self.available = False
    self.UpdateState()

  def OnAvailable(self):
    self.available = True
    self.UpdateState()

  def OnIcdStatus(self, id, type, status, extra):
    if type != 'GPRS':
      return

    if status == 'CONNECTING' or status == 'CONNECTED' or status == 'DISCONNECTING':
      self.internal = True
      self.UpdateState()
    elif status == 'IDLE':
      self.internal = False
      self.UpdateState()

DBusGMainLoop(set_as_default=True)                 
hd_plugin_type = GprsStatusPlugin
