#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QProcess>

class About;
class Help;
class Settings;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:

    // For Connecting Keyboard buttons
    void connectSignals();

    //Button Slots
    void on_pushButtonStart_clicked();

    void on_actionAbout_triggered();

    void on_actionHelp_triggered();

    void on_actionSettings_triggered();

    void on_actionSecureDevice_triggered();

private:
    Ui::MainWindow *ui;
    About *about;
    Help *help;
    Settings *m_settings;
    QProcess *m_process;
};

#endif // MAINWINDOW_H
