#ifndef TRAINING_H
#define TRAINING_H

#include <QDialog>
#include <QTime>
#include <QTimer>
#include <QProcess>

namespace Ui {
class Training;
}

class Training : public QDialog
{
    Q_OBJECT
    
public:
    explicit Training(QWidget *parent = 0);
    ~Training();
    
private slots:
    // For Connecting Keyboard buttons
    void connectSignals();

    //Button Slots
    void on_pushButtonTstart_clicked();

    void on_pushButtonTstop_clicked();

    void on_radioButton30_clicked();

    void on_radioButton60_clicked();

    void on_radioButton120_clicked();

    void on_pushButtonTap_clicked();

    //Timers
    void on_timer();

    void timersStop();

    void on_preTimeout();
    void on_t30Timeout();
    void on_t60Timeout();
    void on_t120Timeout();


private:
    Ui::Training *ui;
    QProcess *t_process;
    QProcess *u_process;
    QProcess *v_process;

    //Timers
    QTime *dTime;
    QTimer *refreshTimer;
    QTimer *preTimer;
    QTimer *t30Timer;
    QTimer *t60Timer;
    QTimer *t120Timer;

};

#endif // TRAINING_H
