#include "training.h"
#include "ui_training.h"

#include <QProcess>
#include <QtCore/QCoreApplication>
#include <QShortcut>
#include <QTime>
#include <QTimer>
#include <QSettings>

Training::Training(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Training),
     t_process(new QProcess(this)),
     u_process(new QProcess(this)),
     v_process(new QProcess(this))
{

    //QLCD Refresh Timer
    refreshTimer = new QTimer(this);
    refreshTimer->setInterval(101);
  //Time
    dTime = new QTime;
  //Timers
    //Pre Start Timer
    preTimer = new QTimer(this);
    preTimer->setInterval(10000);  // 10secs - Pre Start

    //Workout Timers
    t30Timer = new QTimer(this);
    t30Timer->setInterval(30000);     // 30secs
    t60Timer = new QTimer(this);
    t60Timer->setInterval(60000);     // 60secs
    t120Timer = new QTimer(this);
    t120Timer->setInterval(120000);   // 120secs

    ui->setupUi(this);

    //Set Window
    this->setWindowTitle("Training Timer");
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setAttribute(Qt::WA_DeleteOnClose);
    this->setWindowFlags(Qt::Window);

    //Set Button Text
    ui->pushButtonTstart->setText(tr("Start"));
    ui->pushButtonTstop->setText(tr("Stop"));


    // Set Button Icons
    ui->pushButtonTstart->setIcon(QPixmap("/opt/tenminutecore/icons/playback_ff_icon&32.png"));
    ui->pushButtonTstop->setIcon(QPixmap("/opt/tenminutecore/icons/playback_stop_icon&32.png"));
    ui->pushButtonTap->setIcon(QPixmap("/opt/tenminutecore/icons/playback_play_icon&32.png"));

    //Initial LCD display
    ui->lcdNumber->display("rEAdy");

    //Initial Button Settings
    ui->pushButtonTstart->setDisabled(false);
    ui->pushButtonTstop->setDisabled(true);
    ui->radioButton30->setChecked(true);
    ui->radioButton60->setChecked(false);
    ui->radioButton120->setChecked(false);
    ui->labelText->setText("30 Seconds");
    ui->labelReps->setText("Reps");
    ui->lcdNumberReps->display("0");
    int maxrep = QSettings().value("MaximumReps").toInt();
    ui->lcdNumberMax->display(maxrep);

    // For Connecting Keyboard Buttons
    connectSignals();

    connect(refreshTimer, SIGNAL(timeout()), this, SLOT(on_timer()));
    connect(preTimer, SIGNAL(timeout()),this, SLOT (on_preTimeout()));
    connect(t30Timer, SIGNAL(timeout()),this, SLOT(on_t30Timeout()));
    connect(t60Timer, SIGNAL(timeout()),this, SLOT(on_t60Timeout()));
    connect(t120Timer, SIGNAL(timeout()),this, SLOT(on_t120Timeout()));
    //If number of Reps overflows Stop
    connect(ui->lcdNumberReps, SIGNAL(overflow()),this, SLOT(on_pushButtonTstop_clicked()));


}

Training::~Training()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Training::connectSignals()
{

   // Keyboard Key Signals
   connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonStart_clicked()));
   connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonStop_clicked()));
   connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButtonTap_clicked()));
}


void Training::on_timer()
{
   QTime t;
   ui->lcdNumber->display(	t.addMSecs(dTime->elapsed()).toString("mm:ss.zzz"));
}

void Training::timersStop()
{
   t30Timer->stop();
   t60Timer->stop();
   t120Timer->stop();
}

void Training::on_preTimeout()
{
   preTimer->stop();
   refreshTimer->start();
   dTime->restart();
   if (ui->radioButton30->isChecked()) t30Timer->start();
   if (ui->radioButton60->isChecked()) t60Timer->start();
   if (ui->radioButton120->isChecked()) t120Timer->start();
   if (QSettings().value("VibrationAlert") == true)
    v_process->start("dbus-send --system --print-reply --dest=com.nokia.mce\
                    /com/nokia/mce/request com.nokia.mce.request.req_start_manual_vibration int32:250 int32:700");
   if (QSettings().value("AudioAlert") == true)
    t_process->start("aplay /usr/share/sounds/ui-confirmation_note.wav");
}

void Training::on_t30Timeout()
{
    if (QSettings().value("VibrationAlert") == true)
     v_process->start("dbus-send --system --print-reply --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_start_manual_vibration int32:250 int32:700");
    if (QSettings().value("WakeScreen") == true)
     u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    if (QSettings().value("AudioAlert") == true)
     t_process->start("aplay /usr/share/sounds/ui-information_note.wav");
   int val = ui->lcdNumberReps->value();
   int maxrep = QSettings().value("MaximumReps").toInt();
   dTime->restart();
   if (ui->lcdNumberReps->value() != maxrep)
      {
       if (ui->lcdNumberReps->value() < 0)
         {
           refreshTimer->stop();
           preTimer->stop();
           timersStop();
           ui->lcdNumber->display("rEAdy");
           ui->pushButtonTstart->setDisabled(false);
           ui->pushButtonTstop->setDisabled(true);
           ui->lcdNumberReps->display("0");
           ui->labelReps->setText("Reps");
         }
       else
           {
             ui->lcdNumberReps->display(val + 1);
             if (ui->lcdNumberReps->value() == 1) ui->labelReps->setText("Rep");
             if (ui->lcdNumberReps->value() != 1) ui->labelReps->setText("Reps");
             if (ui->lcdNumberReps->value() == maxrep) on_pushButtonTstop_clicked();
             else t30Timer->start();
           }
       }
   else
      {
          on_pushButtonTstop_clicked();
      }
}


void Training::on_t60Timeout()
{
    if (QSettings().value("VibrationAlert") == true)
     v_process->start("dbus-send --system --print-reply --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_start_manual_vibration int32:250 int32:700");
    if (QSettings().value("WakeScreen") == true)
     u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    if (QSettings().value("AudioAlert") == true)
     t_process->start("aplay /usr/share/sounds/ui-information_note.wav");
    int val = ui->lcdNumberReps->value();
    int maxrep = QSettings().value("MaximumReps").toInt();
    dTime->restart();
    if (ui->lcdNumberReps->value() != maxrep)
       {
        if (ui->lcdNumberReps->value() < 0)
          {
            refreshTimer->stop();
            preTimer->stop();
            timersStop();
            ui->lcdNumber->display("rEAdy");
            ui->pushButtonTstart->setDisabled(false);
            ui->pushButtonTstop->setDisabled(true);
            ui->lcdNumberReps->display("0");
            ui->labelReps->setText("Reps");
          }
        else
            {
              ui->lcdNumberReps->display(val + 1);
              if (ui->lcdNumberReps->value() == 1) ui->labelReps->setText("Rep");
              if (ui->lcdNumberReps->value() != 1) ui->labelReps->setText("Reps");
              if (ui->lcdNumberReps->value() == maxrep) on_pushButtonTstop_clicked();
              else t60Timer->start();
            }
        }
    else
       {
           on_pushButtonTstop_clicked();
       }
}

void Training::on_t120Timeout()
{
    if (QSettings().value("VibrationAlert") == true)
     v_process->start("dbus-send --system --print-reply --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_start_manual_vibration int32:250 int32:700");
    if (QSettings().value("WakeScreen") == true)
     u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    if (QSettings().value("AudioAlert") == true)
     t_process->start("aplay /usr/share/sounds/ui-information_note.wav");
    int val = ui->lcdNumberReps->value();
    int maxrep = QSettings().value("MaximumReps").toInt();
    dTime->restart();
    if (ui->lcdNumberReps->value() != maxrep)
       {
        if (ui->lcdNumberReps->value() < 0)
          {
            refreshTimer->stop();
            preTimer->stop();
            timersStop();
            ui->lcdNumber->display("rEAdy");
            ui->pushButtonTstart->setDisabled(false);
            ui->pushButtonTstop->setDisabled(true);
            ui->lcdNumberReps->display("0");
            ui->labelReps->setText("Reps");
          }
        else
            {
              ui->lcdNumberReps->display(val + 1);
              if (ui->lcdNumberReps->value() == 1) ui->labelReps->setText("Rep");
              if (ui->lcdNumberReps->value() != 1) ui->labelReps->setText("Reps");
              if (ui->lcdNumberReps->value() == maxrep) on_pushButtonTstop_clicked();
              else t120Timer->start();
            }
        }
    else
       {
           on_pushButtonTstop_clicked();
       }
}

//pushButtons
void Training::on_pushButtonTstart_clicked()
{
   preTimer->start();
   if (QSettings().value("AudioAlert") == true)
    t_process->start("aplay /usr/share/sounds/ui-information_note.wav");
   ui->lcdNumber->display("PrEParE");
   ui->pushButtonTstart->setDisabled(true);
   ui->pushButtonTstop->setDisabled(false);
   ui->lcdNumberReps->display("0");
   int maxrep = QSettings().value("MaximumReps").toInt();
   ui->lcdNumberMax->display(maxrep);
   ui->lcdNumberMax->show();
   ui->label->show();
   ui->labelReps->setText("Reps");
}

void Training::on_pushButtonTstop_clicked()
{
   refreshTimer->stop();
   preTimer->stop();
   timersStop();
   ui->lcdNumber->display("CEa5E");
   ui->pushButtonTstart->setDisabled(false);
   ui->pushButtonTstop->setDisabled(true);
}

void Training::on_radioButton30_clicked()
{
    refreshTimer->stop();
    preTimer->stop();
    timersStop();
    ui->lcdNumber->display("rEAdy");
    ui->pushButtonTstart->setDisabled(false);
    ui->pushButtonTstop->setDisabled(true);
    ui->radioButton30->setChecked(true);
    ui->radioButton60->setChecked(false);
    ui->radioButton120->setChecked(false);;
    ui->labelText->setText("30 seconds");
    int maxrep = QSettings().value("MaximumReps").toInt();
    ui->lcdNumberMax->display(maxrep);
    ui->lcdNumberMax->show();
    ui->label->show();
    ui->lcdNumberReps->display("0");
    ui->labelReps->setText("Reps");
}

void Training::on_radioButton60_clicked()
{
    refreshTimer->stop();
    preTimer->stop();
    timersStop();
    ui->lcdNumber->display("rEAdy");
    ui->pushButtonTstart->setDisabled(false);
    ui->pushButtonTstop->setDisabled(true);
    ui->radioButton30->setChecked(false);
    ui->radioButton60->setChecked(true);
    ui->radioButton120->setChecked(false);
    ui->labelText->setText("60 seconds");
    int maxrep = QSettings().value("MaximumReps").toInt();
    ui->lcdNumberMax->display(maxrep);
    ui->lcdNumberMax->show();
    ui->label->show();
    ui->lcdNumberReps->display("0");
    ui->labelReps->setText("Reps");
}

void Training::on_radioButton120_clicked()
{
    refreshTimer->stop();
    preTimer->stop();
    timersStop();
    ui->lcdNumber->display("rEAdy");
    ui->pushButtonTstart->setDisabled(false);
    ui->pushButtonTstop->setDisabled(true);
    ui->radioButton30->setChecked(false);
    ui->radioButton60->setChecked(false);
    ui->radioButton120->setChecked(true);
    ui->labelText->setText("120 seconds");
    int maxrep = QSettings().value("MaximumReps").toInt();
    ui->lcdNumberMax->display(maxrep);
    ui->lcdNumberMax->show();
    ui->label->show();
    ui->lcdNumberReps->display("0");
    ui->labelReps->setText("Reps");
}

void Training::on_pushButtonTap_clicked()
{
    refreshTimer->stop();
    preTimer->stop();
    timersStop();
    if (ui->radioButton30->isChecked()) t30Timer->start();
    if (ui->radioButton60->isChecked()) t60Timer->start();
    if (ui->radioButton120->isChecked()) t120Timer->start();
    refreshTimer->start();
    dTime->restart();
    ui->pushButtonTstart->setDisabled(true);
    ui->pushButtonTstop->setDisabled(false);
    ui->lcdNumberReps->display("-1");
    ui->lcdNumberMax->hide();
    ui->label->hide();
    ui->labelReps->setText("Tap Rep");
}
