#include "settings.h"
#include "ui_settings.h"

#include <QtCore/QCoreApplication>
#include <QProcess>
#include <QFileInfo>
#include <QSettings>
#include <QString>


Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)

{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle("Settings");
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //If settings don't exist, set values
    QSettings settings("tenminutecore", "tenminutecore");

    if (!settings.contains("SecureSettingSilent")) settings.setValue("SecureSettingSilent", false);
    if (!settings.contains("GeneralOnClose")) settings.setValue("GeneralOnClose", false);

    if (!settings.contains("WakeScreen")) settings.setValue("WakeScreen", false);
    if (!settings.contains("AudioAlert")) settings.setValue("AudioAlert", true);
    if (!settings.contains("VibrationAlert")) settings.setValue("VibrationAlert", false);
    if (!settings.contains("SpeechAlert")) settings.setValue("SpeechAlert", true);

    //Draw Initial Checkboxes
    ui->checkBoxSecureSetting->setChecked(QSettings().value("SecureSettingSilent", true).toBool());
    ui->checkBoxGeneralSetting->setChecked(QSettings().value("GeneralOnClose", true).toBool());

    ui->checkBoxWakeScr->setChecked(QSettings().value("WakeScreen", true).toBool());
    ui->checkBoxAudio->setChecked(QSettings().value("AudioAlert", true).toBool());
    ui->checkBoxVibra->setChecked(QSettings().value("VibrationAlert", true).toBool());
    ui->checkBoxSpeech->setChecked(QSettings().value("SpeechAlert", true).toBool());


    //Draw and Setup Initial QSlider
     if (QSettings().contains("MaximumReps"))
     {
       int maxrep = QSettings().value("MaximumReps").toInt();
       ui->horizontalSlider->setValue(maxrep);
       ui->lcdNumberShowReps->display(maxrep);
     }
     else
     {
       QSettings().setValue("MaximumReps", 12);
       int maxrep = QSettings().value("MaximumReps").toInt();
       ui->horizontalSlider->setValue(maxrep);
       ui->lcdNumberShowReps->display(maxrep);
     }

     //Set Button Text
     ui->pushButtonMinusTen->setText(tr(""));
     ui->pushButtonMinusOne->setText(tr(""));
     ui->pushButtonPlusOne->setText(tr(""));
     ui->pushButtonPlusTen->setText(tr(""));

     // Set Button Icons
     ui->pushButtonMinusTen->setIcon(QPixmap("/opt/tenminutecore/icons/rewind_previous_icon&32.png"));
     ui->pushButtonMinusOne->setIcon(QPixmap("/opt/tenminutecore/icons/playback_prev_icon&32.png"));
     ui->pushButtonPlusOne->setIcon(QPixmap("/opt/tenminutecore/icons/playback_next_icon&32.png"));
     ui->pushButtonPlusTen->setIcon(QPixmap("/opt/tenminutecore/icons/fastforward_next_icon&32.png"));

     QSettings().sync();

}
Settings::~Settings()
{
    delete ui;
}

void Settings::on_checkBoxSecureSetting_clicked()
{
    if (ui->checkBoxSecureSetting->isChecked()) QSettings().setValue("SecureSettingSilent", "true");
    else QSettings().setValue("SecureSettingSilent", "false");
    QSettings().sync();
}

void Settings::on_checkBoxGeneralSetting_clicked()
{
    if (ui->checkBoxGeneralSetting->isChecked()) QSettings().setValue("GeneralOnClose", "true");
    else QSettings().setValue("GeneralOnClose", "false");
    QSettings().sync();
}

void Settings::on_checkBoxWakeScr_clicked()
{
    if (ui->checkBoxWakeScr->isChecked()) QSettings().setValue("WakeScreen", "true");
    else QSettings().setValue("WakeScreen", "false");
    QSettings().sync();
}

void Settings::on_checkBoxAudio_clicked()
{
    if (ui->checkBoxAudio->isChecked()) QSettings().setValue("AudioAlert", "true");
    else QSettings().setValue("AudioAlert", "false");
    QSettings().sync();
}

void Settings::on_checkBoxVibra_clicked()
{
    if (ui->checkBoxVibra->isChecked()) QSettings().setValue("VibrationAlert", "true");
    else QSettings().setValue("VibrationAlert", "false");
    QSettings().sync();
}

void Settings::on_checkBoxSpeech_clicked()
{
    if (ui->checkBoxSpeech->isChecked()) QSettings().setValue("SpeechAlert", "true");
    else QSettings().setValue("SpeechAlert", "false");
    QSettings().sync();
}

void Settings::on_horizontalSlider_valueChanged(int maxrep)
{
    ui->horizontalSlider->setValue(maxrep);
    ui->lcdNumberShowReps->display(maxrep);
}

void Settings::on_pushButtonMinusTen_clicked()
{
    int maxrep = ui->lcdNumberShowReps->value();
    if (maxrep >10) ui->horizontalSlider->setValue(maxrep - 10);
    if (maxrep >10) ui->lcdNumberShowReps->display(maxrep - 10);
}

void Settings::on_pushButtonMinusOne_clicked()
{
    int maxrep = ui->lcdNumberShowReps->value();
    if (maxrep >1) ui->horizontalSlider->setValue(maxrep - 1);
    if (maxrep >1) ui->lcdNumberShowReps->display(maxrep - 1);
}

void Settings::on_pushButtonPlusOne_clicked()
{
    int maxrep = ui->lcdNumberShowReps->value();
    if (maxrep <99) ui->horizontalSlider->setValue(maxrep + 1);
    if (maxrep <99) ui->lcdNumberShowReps->display(maxrep + 1);
}

void Settings::on_pushButtonPlusTen_clicked()
{
    int maxrep = ui->lcdNumberShowReps->value();
    if (maxrep <90) ui->horizontalSlider->setValue(maxrep + 10);
    if (maxrep <90) ui->lcdNumberShowReps->display(maxrep + 10);
}

void Settings::on_pushButtonSave_clicked()
{
    QSettings().setValue("MaximumReps", ui->horizontalSlider->value());
    QSettings().sync();
}

void Settings::on_pushButtonDefault_clicked()
{
    QSettings().setValue("MaximumReps", 12);
    int maxrep = QSettings().value("MaximumReps").toInt();
    ui->horizontalSlider->setValue(maxrep);
    QSettings().sync();
}

