#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QProcess>
#include <QTime>
#include <QTimer>

class About;
class Help;
class Settings;
class Training;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:

    // For Connecting Keyboard buttons
    void connectSignals();

    //Button Slots
    void on_pushButtonStart_clicked();

    void on_pushButtonStop_clicked();

    void on_actionAbout_triggered();

    void on_actionHelp_triggered();

    void on_actionSettings_triggered();

    void on_actionTraining_triggered();

    void on_actionSecureDevice_triggered();

    //Initial Warning
    void initialseen();
    void initialshow();

    //Timers
    void on_timer();

    void timersStart();
    void timersStop();

    void on_preTimeout();
    void on_aTimeout();
    void on_bTimeout();
    void on_cTimeout();
    void on_dTimeout();
    void on_eTimeout();
    void on_fTimeout();
    void on_gTimeout();
    void on_hTimeout();
    void on_iTimeout();
    void on_jTimeout();
    void on_kTimeout();
    void on_lTimeout();
    void on_mTimeout();
    void on_nTimeout();
    void on_oTimeout();
    void on_pTimeout();
    void on_zTimeout();

private:
    Ui::MainWindow *ui;
    About *about;
    Help *help;
    Settings *m_settings;
    Training *training;
    QProcess *l_process;
    QProcess *m_process;
    QProcess *u_process;
    QProcess *v_process;

    //Timers
    QTime *dTime;
    QTimer *refreshTimer;
    QTimer *preTimer;
    QTimer *aTimer;
    QTimer *bTimer;
    QTimer *cTimer;
    QTimer *dTimer;
    QTimer *eTimer;
    QTimer *fTimer;
    QTimer *gTimer;
    QTimer *hTimer;
    QTimer *iTimer;
    QTimer *jTimer;
    QTimer *kTimer;
    QTimer *lTimer;
    QTimer *mTimer;
    QTimer *nTimer;
    QTimer *oTimer;
    QTimer *pTimer;
    QTimer *zTimer;
};

#endif // MAINWINDOW_H
