#include "training.h"
#include "ui_training.h"

#include <QProcess>
#include <QtCore/QCoreApplication>
#include <QShortcut>
#include <QTime>
#include <QTimer>

Training::Training(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Training),
     t_process(new QProcess(this)),
     u_process(new QProcess(this))
{

    //QLCD Refresh Timer
    refreshTimer = new QTimer(this);
    refreshTimer->setInterval(121);
  //Time
    dTime = new QTime;
  //Timers
    //Pre Start Timer
    preTimer = new QTimer(this);
    preTimer->setInterval(10000);  // 10secs - Pre Start

    //Workout Timers
    t30Timer = new QTimer(this);
    t30Timer->setInterval(30000);     // 30secs
    t60Timer = new QTimer(this);
    t60Timer->setInterval(60000);     // 60secs
    t120Timer = new QTimer(this);
    t120Timer->setInterval(120000);   // 120secs

    ui->setupUi(this);

    //Set Window
    this->setWindowTitle("Training Timer");
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setAttribute(Qt::WA_DeleteOnClose);
    this->setWindowFlags(Qt::Window);

    //Set Button Text
    ui->pushButtonTstart->setText(tr("Start"));
    ui->pushButtonTstop->setText(tr("Stop"));


    // Set Button Icons
    ui->pushButtonTstart->setIcon(QPixmap("/opt/tenminutecore/icons/playback_play_icon&32.png"));
    ui->pushButtonTstop->setIcon(QPixmap("/opt/tenminutecore/icons/playback_stop_icon&32.png"));

    //Initial LCD display
    ui->lcdNumber->display("rEAdy");

    //Initial Button Settings
    ui->pushButtonTstart->setDisabled(false);
    ui->pushButtonTstop->setDisabled(true);
    ui->pushButton30->setDisabled(true);
    ui->pushButton60->setDisabled(false);
    ui->pushButton120->setDisabled(false);
    ui->labelText->setText("30 Seconds");
    ui->labelReps->setText("Reps");
    ui->lcdNumberReps->display("0");

    // For Connecting Keyboard Buttons
    connectSignals();

    connect(refreshTimer, SIGNAL(timeout()), this, SLOT(on_timer()));
    connect(preTimer, SIGNAL(timeout()),this, SLOT (on_preTimeout()));
    connect(t30Timer, SIGNAL(timeout()),this, SLOT(on_t30Timeout()));
    connect(t60Timer, SIGNAL(timeout()),this, SLOT(on_t60Timeout()));
    connect(t120Timer, SIGNAL(timeout()),this, SLOT(on_t120Timeout()));
    //If number of Reps overflows Stop
    connect(ui->lcdNumberReps, SIGNAL(overflow()),this, SLOT(on_pushButtonTstop_clicked()));


}

Training::~Training()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Training::connectSignals()
{

   // Keyboard Key Signals
   connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonStart_clicked()));
   connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonStop_clicked()));
}


void Training::on_timer()
{
   QTime t;
   ui->lcdNumber->display(	t.addMSecs(dTime->elapsed()).toString("mm:ss.zzz"));
}

void Training::timersStop()
{
   t30Timer->stop();
   t60Timer->stop();
   t120Timer->stop();
}

void Training::on_preTimeout()
{
   preTimer->stop();
   refreshTimer->start();
   dTime->restart();
   if (!ui->pushButton30->isEnabled()) t30Timer->start();
   if (!ui->pushButton60->isEnabled()) t60Timer->start();
   if (!ui->pushButton120->isEnabled()) t120Timer->start();
   t_process->start("aplay /usr/share/sounds/ui-confirmation_note.wav");
}

void Training::on_t30Timeout()
{
   u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                    /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
   t_process->start("aplay /usr/share/sounds/ui-information_note.wav");
   int val = ui->lcdNumberReps->value();
   ui->lcdNumberReps->display(val + 1);
   if (ui->lcdNumberReps->value() == 1) ui->labelReps->setText("Rep");
   if (ui->lcdNumberReps->value() != 1) ui->labelReps->setText("Reps");
   dTime->restart();
   t30Timer->start();
}

void Training::on_t60Timeout()
{
   u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                    /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
   t_process->start("aplay /usr/share/sounds/ui-information_note.wav");
   int val = ui->lcdNumberReps->value();
   ui->lcdNumberReps->display(val + 1);
   if (ui->lcdNumberReps->value() == 1) ui->labelReps->setText("Rep");
   if (ui->lcdNumberReps->value() != 1) ui->labelReps->setText("Reps");
   dTime->restart();
   t60Timer->start();
}

void Training::on_t120Timeout()
{
   u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                    /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
   t_process->start("aplay /usr/share/sounds/ui-information_note.wav");
   int val = ui->lcdNumberReps->value();
   ui->lcdNumberReps->display(val + 1);
   if (ui->lcdNumberReps->value() == 1) ui->labelReps->setText("Rep");
   if (ui->lcdNumberReps->value() != 1) ui->labelReps->setText("Reps");
   dTime->restart();
   t120Timer->start();
}

//pushButtons
void Training::on_pushButtonTstart_clicked()
{
   preTimer->start();
   t_process->start("aplay /usr/share/sounds/ui-information_note.wav");
   ui->lcdNumber->display("PrEParE");
   ui->pushButtonTstart->setDisabled(true);
   ui->pushButtonTstop->setDisabled(false);
   ui->lcdNumberReps->display("0");
   ui->labelReps->setText("Reps");
}

void Training::on_pushButtonTstop_clicked()
{
   refreshTimer->stop();
   preTimer->stop();
   timersStop();
   ui->lcdNumber->display("CEa5E");
   ui->pushButtonTstart->setDisabled(false);
   ui->pushButtonTstop->setDisabled(true);
}

void Training::on_pushButton30_clicked()
{
    refreshTimer->stop();
    preTimer->stop();
    timersStop();
    ui->lcdNumber->display("rEAdy");
    ui->pushButtonTstart->setDisabled(false);
    ui->pushButtonTstop->setDisabled(true);
    ui->pushButton30->setDisabled(true);
    ui->pushButton60->setDisabled(false);
    ui->pushButton120->setDisabled(false);
    ui->labelText->setText("30 seconds");

}

void Training::on_pushButton60_clicked()
{
    refreshTimer->stop();
    preTimer->stop();
    timersStop();
    ui->lcdNumber->display("rEAdy");
    ui->pushButtonTstart->setDisabled(false);
    ui->pushButtonTstop->setDisabled(true);
    ui->pushButton30->setDisabled(false);
    ui->pushButton60->setDisabled(true);
    ui->pushButton120->setDisabled(false);
    ui->labelText->setText("60 seconds");
}

void Training::on_pushButton120_clicked()
{
    refreshTimer->stop();
    preTimer->stop();
    timersStop();
    ui->lcdNumber->display("rEAdy");
    ui->pushButtonTstart->setDisabled(false);
    ui->pushButtonTstop->setDisabled(true);
    ui->pushButton30->setDisabled(false);
    ui->pushButton60->setDisabled(false);
    ui->pushButton120->setDisabled(true);
    ui->labelText->setText("120 seconds");
}
