/*-------------------------------------------
Ten Minute Core Workout
Designed by sixwheeledbeast
Inspired by theclimbinghangar
theclimbinghangar.com
--------------------------------------------*/

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "about.h"
#include "help.h"
#include "settings.h"
#include "training.h"

#include <QProcess>
#include <QtCore/QCoreApplication>
#include <QDesktopServices>
#include <QShortcut>
#include <QUrl>
#include <QSettings>
#include <QMaemo5InformationBox>
#include <QTime>
#include <QTimer>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow),
      about(0),
      help(0),
      m_settings(0),
       m_process(new QProcess(this)),
       u_process(new QProcess(this))

{
        //QLCD Refresh Timer
        refreshTimer = new QTimer(this);
        refreshTimer->setInterval(121);
    //Time
        dTime = new QTime;
    //Timers
        //Pre Start Timer
        preTimer = new QTimer(this);
        preTimer->setInterval(10000);  // 10secs - Pre Start

        //Workout Timers
        aTimer = new QTimer(this);
        aTimer->setInterval(30000);    // 30secs - Dish
        bTimer = new QTimer(this);
        bTimer->setInterval(60000);    // +30secs - Sit ups
        cTimer = new QTimer(this);
        cTimer->setInterval(120000);   // +60secs - Cycling
        dTimer = new QTimer(this);
        dTimer->setInterval(150000);   // +30secs - Tabletop
        eTimer = new QTimer(this);
        eTimer->setInterval(180000);   // +30secs - side crunch right
        fTimer = new QTimer(this);
        fTimer->setInterval(210000);   // +30secs - side crunch left
        gTimer = new QTimer(this);
        gTimer->setInterval(240000);   // +30secs - ab crunches
        hTimer = new QTimer(this);
        hTimer->setInterval(270000);   // +30secs - push up's
        iTimer = new QTimer(this);
        iTimer->setInterval(330000);   // +60secs - Plank
        jTimer = new QTimer(this);
        jTimer->setInterval(360000);   // +30secs - Dish
        kTimer = new QTimer(this);
        kTimer->setInterval(390000);   // +30secs - double leg pressouts
        lTimer = new QTimer(this);
        lTimer->setInterval(450000);   // +60secs - Cycling
        mTimer = new QTimer(this);
        mTimer->setInterval(480000);   // +30secs - side crunch right
        nTimer = new QTimer(this);
        nTimer->setInterval(510000);   // +30secs - side crunch left
        oTimer = new QTimer(this);
        oTimer->setInterval(540000);   // +30secs - Dish
        pTimer = new QTimer(this);
        pTimer->setInterval(570000);   // +30secs - ab crunches
        zTimer = new QTimer(this);
        zTimer->setInterval(600000);   // +30secs - Cycling / Stop

      ui->setupUi(this);

      setAttribute(Qt::WA_Maemo5StackedWindow);
      about = new About(this);
      help = new Help(this);
      m_settings = new Settings(this);


    // For Connecting Keyboard Buttons
      connectSignals();

      ui->pushButtonStart->setDisabled(false);
      ui->pushButtonStop->setDisabled(true);

      connect(refreshTimer, SIGNAL(timeout()), this, SLOT(on_timer()));
      connect(preTimer, SIGNAL(timeout()),this, SLOT (on_preTimeout()));
      connect(aTimer, SIGNAL(timeout()),this, SLOT(on_aTimeout()));
      connect(bTimer, SIGNAL(timeout()),this, SLOT(on_bTimeout()));
      connect(cTimer, SIGNAL(timeout()),this, SLOT(on_cTimeout()));
      connect(dTimer, SIGNAL(timeout()),this, SLOT(on_dTimeout()));
      connect(eTimer, SIGNAL(timeout()),this, SLOT(on_eTimeout()));
      connect(fTimer, SIGNAL(timeout()),this, SLOT(on_fTimeout()));
      connect(gTimer, SIGNAL(timeout()),this, SLOT(on_gTimeout()));
      connect(hTimer, SIGNAL(timeout()),this, SLOT(on_hTimeout()));
      connect(iTimer, SIGNAL(timeout()),this, SLOT(on_iTimeout()));
      connect(jTimer, SIGNAL(timeout()),this, SLOT(on_jTimeout()));
      connect(kTimer, SIGNAL(timeout()),this, SLOT(on_kTimeout()));
      connect(lTimer, SIGNAL(timeout()),this, SLOT(on_lTimeout()));
      connect(mTimer, SIGNAL(timeout()),this, SLOT(on_mTimeout()));
      connect(nTimer, SIGNAL(timeout()),this, SLOT(on_nTimeout()));
      connect(oTimer, SIGNAL(timeout()),this, SLOT(on_oTimeout()));
      connect(pTimer, SIGNAL(timeout()),this, SLOT(on_pTimeout()));
      connect(zTimer, SIGNAL(timeout()),this, SLOT(on_zTimeout()));

      //Set Window
      this->setWindowTitle("Ten Minute Core");

      //Set Button Text
      ui->pushButtonStart->setText(tr("Start"));
      ui->pushButtonStop->setText(tr("Stop"));


      // Set Button Icons
      ui->pushButtonStart->setIcon(QPixmap("/opt/tenminutecore/icons/playback_play_icon&32.png"));
      ui->pushButtonStop->setIcon(QPixmap("/opt/tenminutecore/icons/playback_stop_icon&32.png"));

      //Initial LCD display
      ui->lcdNumber->display("rEAdy");

      //Initial blank GIF image
      ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/blank.gif"));

      //Inital blank Text
      ui->labelText->setText("-");

      //First Start Banner
      initialshow();
}

MainWindow::~MainWindow()
{
    initialseen();

    if (about) delete (about);
    if (help) delete (help);
    if (m_settings) delete (m_settings);
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}


// Keyboard Button Signals - remember to include QShortcut
void MainWindow::connectSignals()
{

// Keyboard Key Signals
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonStart_clicked()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonStop_clicked()));
}

//Initial Setup Text
void MainWindow::initialshow()
{
   QSettings settings("tenminutecore", "tenminutecore");

   if (!settings.contains("InitialWarningShown"))
       {
        QMaemo5InformationBox::information(
          0,
          " <br> \
            <br> \
          Thank you for installing tenminutecore. <br> \
          Using Espeak this simple program will instruct you through a 10 minute, no rest core exercise. <br> \
          This package contains a secure device option, do not use this feature without knowing your device lockcode. <br> \
          <br> ",
          0);
       }
}

//Initial Warning Seen
void MainWindow::initialseen()
{
    QSettings settings("tenminutecore", "tenminutecore");

    if (!settings.contains("InitialWarningShown"))
        {
         settings.setValue("InitialWarningShown", true);
        }
}

void MainWindow::on_timer()
{
    QTime t;
    ui->lcdNumber->display(	t.addMSecs(dTime->elapsed()).toString("mm:ss.zzz"));
}

void MainWindow::timersStart()
{
    aTimer->start();
    bTimer->start();
    cTimer->start();
    dTimer->start();
    eTimer->start();
    fTimer->start();
    gTimer->start();
    hTimer->start();
    iTimer->start();
    jTimer->start();
    kTimer->start();
    lTimer->start();
    mTimer->start();
    nTimer->start();
    oTimer->start();
    pTimer->start();
    zTimer->start();
}

void MainWindow::timersStop()
{
    aTimer->stop();
    bTimer->stop();
    cTimer->stop();
    dTimer->stop();
    eTimer->stop();
    fTimer->stop();
    gTimer->stop();
    hTimer->stop();
    iTimer->stop();
    jTimer->stop();
    kTimer->stop();
    lTimer->stop();
    mTimer->stop();
    nTimer->stop();
    oTimer->stop();
    pTimer->stop();
    zTimer->stop();
}

void MainWindow::on_preTimeout()
{
    preTimer->stop();
    refreshTimer->start();
    dTime->restart();
    timersStart();
    m_process->start("espeak 'start_dish_exercise_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/dish.gif"));
    ui->labelText->setText("Dish");
}

void MainWindow::on_aTimeout()
{
    aTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_sit_ups_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/situp.gif"));
    ui->labelText->setText("Sit-ups");
}

void MainWindow::on_bTimeout()
{
    bTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_cycling_in_the_air_for_1_minute'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/cycling.gif"));
    ui->labelText->setText("Cycling in Air");
}

void MainWindow::on_cTimeout()
{
    cTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_holding_tabletop_position_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/tabletopstatic.gif"));
    ui->labelText->setText("Tabletop Hold");
}

void MainWindow::on_dTimeout()
{
    dTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_side_crunches_on_right_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/rs_crunch.gif"));
    ui->labelText->setText("Right Crunches");
}

void MainWindow::on_eTimeout()
{
    eTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_side_crunches_on_left_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/ls_crunch.gif"));
    ui->labelText->setText("Left Crunches");
}

void MainWindow::on_fTimeout()
{
    fTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_ab_crunches_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/abcrunch.gif"));
    ui->labelText->setText("Ab Crunches");
}

void MainWindow::on_gTimeout()
{
    gTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_push_ups_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/pushupstatic.gif"));
    ui->labelText->setText("Push ups");
}

void MainWindow::on_hTimeout()
{
    hTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_plank_exercise_for_1_minute'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/plank.gif"));
    ui->labelText->setText("Plank");
}

void MainWindow::on_iTimeout()
{
    iTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_dish_exercise_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/dish.gif"));
    ui->labelText->setText("Dish");
}

void MainWindow::on_jTimeout()
{
    jTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_double_leg_press_outs_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/pressouts.gif"));
    ui->labelText->setText("Leg Pressouts");
}

void MainWindow::on_kTimeout()
{
    kTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_cycling_in_the_air_for_1_minute'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/cycling.gif"));
    ui->labelText->setText("Cycling in Air");
}

void MainWindow::on_lTimeout()
{
    lTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_side_crunches_on_right_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/rs_crunch.gif"));
    ui->labelText->setText("Right Crunches");
}

void MainWindow::on_mTimeout()
{
    mTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_side_crunches_on_left_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/ls_crunch.gif"));
    ui->labelText->setText("Left Crunches");
}

void MainWindow::on_nTimeout()
{
    nTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_dish_exercise_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/dish.gif"));
    ui->labelText->setText("Dish");
}

void MainWindow::on_oTimeout()
{
    oTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_ab_crunches_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/abcrunch.gif"));
    ui->labelText->setText("Ab Crunches");
}

void MainWindow::on_pTimeout()
{
    pTimer->stop();
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                                        /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'start_cycling_in_the_air_for_30_seconds'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/cycling.gif"));
    ui->labelText->setText("Cycling in Air");
}

void MainWindow::on_zTimeout()
{
    refreshTimer->stop();
    timersStop();
    ui->pushButtonStart->setDisabled(false);
    ui->pushButtonStop->setDisabled(true);
    ui->lcdNumber->display("CEa5E");
    u_process->start("dbus-send --print-reply --system --dest=com.nokia.mce\
                     /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:unlocked");
    m_process->start("espeak 'exercise_complete'");
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/blank.gif"));
    ui->labelText->setText("-");
}

//pushButtons
void MainWindow::on_pushButtonStart_clicked()
{
    preTimer->start();
    m_process->start("espeak 'starting_10_minute_core_workout_in_10_seconds'");
    ui->lcdNumber->display("PrEParE");
    ui->pushButtonStart->setDisabled(true);
    ui->pushButtonStop->setDisabled(false);
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/flex.gif"));
    ui->labelText->setText("---");
}

void MainWindow::on_pushButtonStop_clicked()
{
    refreshTimer->stop();
    preTimer->stop();
    timersStop();
    ui->lcdNumber->display("CEa5E");
    ui->pushButtonStart->setDisabled(false);
    ui->pushButtonStop->setDisabled(true);
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/blank.gif"));
    ui->labelText->setText("-");
}

//Actions
void MainWindow::on_actionAbout_triggered()
{
    about->show();
}

void MainWindow::on_actionHelp_triggered()
{
    help->show();
}

void MainWindow::on_actionTraining_triggered()
{
    refreshTimer->stop();
    preTimer->stop();
    timersStop();
    ui->lcdNumber->display("CEa5E");
    ui->pushButtonStart->setDisabled(false);
    ui->pushButtonStop->setDisabled(true);
    ui->labelGif->setPixmap(QPixmap("/opt/tenminutecore/gif/blank.gif"));
    ui->labelText->setText("-");
    training = new Training(this);
    training->show();
}

void MainWindow::on_actionSettings_triggered()
{
    m_settings->show();
}

void MainWindow::on_actionSecureDevice_triggered()
{
      QSettings settings;
      if ( settings.value("SecureSettingSilent","true").toString()=="true" )
      {
          m_process->start("sh opt/tenminutecore/script/lkscsl.sh");
      }
      else
      {
          m_process->start("sh opt/tenminutecore/script/lksc.sh");
      }
}

