"""
Some handy constants for other tests to share and enjoy.
"""

from dbus import PROPERTIES_IFACE

HT_CONTACT = 1
HT_ROOM =2
HT_CONTACT_LIST = 3

CHANNEL = "org.freedesktop.Telepathy.Channel"
CHANNEL_IFACE_GROUP = CHANNEL + ".Interface.Group"
CHANNEL_TYPE_TUBES = CHANNEL + ".Type.Tubes"
CHANNEL_IFACE_TUBE = CHANNEL + ".Interface.Tube.DRAFT"
CHANNEL_TYPE_DBUS_TUBE = CHANNEL + ".Type.DBusTube.DRAFT"
CHANNEL_TYPE_STREAM_TUBE = CHANNEL + ".Type.StreamTube.DRAFT"
CHANNEL_TYPE_CONTACT_LIST = CHANNEL + ".Type.ContactList"
CHANNEL_TYPE_FILE_TRANSFER = CHANNEL + ".Type.FileTransfer"
CHANNEL_TYPE_TEXT = CHANNEL + ".Type.Text"
CHANNEL_TYPE_CONTACT_LIST = CHANNEL + ".Type.ContactList"

CHANNEL_TYPE = CHANNEL + '.ChannelType'
TARGET_HANDLE_TYPE = CHANNEL + '.TargetHandleType'
TARGET_HANDLE = CHANNEL + '.TargetHandle'
TARGET_ID = CHANNEL + '.TargetID'
REQUESTED = CHANNEL + '.Requested'
INITIATOR_HANDLE = CHANNEL + '.InitiatorHandle'
INITIATOR_ID = CHANNEL + '.InitiatorID'
INTERFACES = CHANNEL + '.Interfaces'

CONN = "org.freedesktop.Telepathy.Connection"
CONN_IFACE_REQUESTS = CONN + '.Interface.Requests'
CONN_IFACE_CONTACT_CAPA = CONN + '.Interface.ContactCapabilities.DRAFT'
CONN_IFACE_CONTACTS = CONN + '.Interface.Contacts'

ERRORS = 'org.freedesktop.Telepathy.Errors'
INVALID_ARGUMENT = ERRORS + '.InvalidArgument'
NOT_IMPLEMENTED = ERRORS + '.NotImplemented'
NOT_AVAILABLE = ERRORS + '.NotAvailable'

TUBE_PARAMETERS = CHANNEL_IFACE_TUBE + '.Parameters'
TUBE_STATE = CHANNEL_IFACE_TUBE + '.State'
STREAM_TUBE_SERVICE = CHANNEL_TYPE_STREAM_TUBE + '.Service'
DBUS_TUBE_SERVICE_NAME = CHANNEL_TYPE_DBUS_TUBE + '.ServiceName'

TUBE_CHANNEL_STATE_LOCAL_PENDING = 0
TUBE_CHANNEL_STATE_REMOTE_PENDING = 1
TUBE_CHANNEL_STATE_OPEN = 2
TUBE_CHANNEL_STATE_NOT_OFFERED = 3

FT_CONTENT_TYPE = CHANNEL_TYPE_FILE_TRANSFER + ".ContentType"
FT_FILENAME = CHANNEL_TYPE_FILE_TRANSFER + ".Filename"
FT_SIZE = CHANNEL_TYPE_FILE_TRANSFER + ".Size"
FT_CONTENT_HASH_TYPE = CHANNEL_TYPE_FILE_TRANSFER + ".ContentHashType"
FT_CONTENT_HASH = CHANNEL_TYPE_FILE_TRANSFER + ".ContentHash"
FT_DESCRIPTION = CHANNEL_TYPE_FILE_TRANSFER + ".Description"
FT_DATE = CHANNEL_TYPE_FILE_TRANSFER + ".Date"
FT_INITIAL_OFFSET = CHANNEL_TYPE_FILE_TRANSFER + ".InitialOffset"

TEXT_MESSAGE_TYPE_NORMAL = 0

SOCKET_ADDRESS_TYPE_UNIX = 0
SOCKET_ADDRESS_TYPE_ABSTRACT_UNIX = 1
SOCKET_ADDRESS_TYPE_IPV4 = 2
SOCKET_ADDRESS_TYPE_IPV6 = 3

SOCKET_ACCESS_CONTROL_LOCALHOST = 0
SOCKET_ACCESS_CONTROL_PORT = 1
SOCKET_ACCESS_CONTROL_NETMASK = 2
SOCKET_ACCESS_CONTROL_CREDENTIALS = 3
