'''
Task Poach - Strives to be a Task Coach compatible TODO app.
Copyright (C) 2012 computerinfo21@gmail.com>

Task Poach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Poach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import re
from PyQt4.QtGui import QSortFilterProxyModel
from PyQt4.QtCore import QRegExp, Qt

class NumberSortModel(QSortFilterProxyModel):
    
    def lessThan(self, left, right):
        lvalue = left.data().toDouble()[0]
        rvalue = right.data().toDouble()[0]
        
        if lvalue == 0:
            lvalue = -999999999999
        if rvalue == 0:
            rvalue = -999999999999
            
        return lvalue > rvalue
  
class TextSortModel(QSortFilterProxyModel):
    
    def __init__(self, parent):
        super(TextSortModel, self).__init__()
        #self.hidecompleted = hidecompleted
        #print id(self.hidecompleted)
        #print id(self.parent)
        self.parent = parent
        
    def filterAcceptsRow(self, sourceRow, sourceParent):
        #if self.filterRegExp() == "" :
            #print "this applies"
            #return True #Shortcut for common case

        #Only accept it if the super version would and we can filter further based on other options
        if  super(TextSortModel, self).filterAcceptsRow( sourceRow, sourceParent) :
            #print sourceRow
            #return True
            #print dir(self.hidecompleted)
            #print self.sourceModel().item(sourceRow, 0).data().toPyObject()
            #print id(self.hidecompleted)
        
            if self.parent.parent.hideCompleted():
                #print "Hide completed"
                index = self.sourceModel().index(sourceRow, 0, sourceParent)
                data = self.sourceModel().itemFromIndex(index).data().toPyObject()
                #print data
                try:
                    data.attrib["completiondate"]
                except KeyError:
                    #print "no completion date"
                    return True
                else:
                    #print data.attrib["completiondate"]
                    return False
            else:
                return True
        else:
            return False

    def lessThan(self, left, right):
        
        lvalue = self.sourceModel().itemFromIndex(left).text()
        rvalue = self.sourceModel().itemFromIndex(right).text()
        
        if lvalue == "":
            lvalue = "999999999999"
        if rvalue == "":
            rvalue = "999999999999"
        
        return lvalue < rvalue

class filterManager():
    def __init__(self, parent):
        self.__filterStr = ""
        self.__filterCol = 4
        self.parent = parent
        #for keeping track of categories chosen (the category id) to view
        self.viewSelectedCategories = []
        #a list of all of the items of selected categories
        self.viewSelectedCategoryItemIds = []
        #for keeping track of the actual element items of categories to view (to refresh categorizables as needed
        self.viewSelectedCategoriesElements = []
    
    #Store the filter to access/reapply
    def getFilterString(self):
        return self.__filterStr
    
    def setFilterString(self, filterStr):
        self.__filterStr = filterStr
        
    #Store the filter to access/reapply
    def getFilterCol(self):
        return self.__filterCol
    
    def setFilterCol(self, filterCol):
        self.__filterCol = filterCol
        
    def applyFilter(self):
        self.parent.model.proxy.setFilterRegExp(QRegExp(re.sub(' ', '|', self.__filterStr), Qt.CaseInsensitive))
        self.parent.model.proxy.setFilterKeyColumn(self.__filterCol);
        
    def preventEmptyFilter(self):
        if self.__filterStr == "":
            #print "There is nothing in selected categories"
            self.__filterStr = "NoThIngHeREToFILTER"
        
    def filterTasks(self):
        #filtering
        #string = "1122523944:1316750205.88|1176369096:1317327419.7|1123226512:1317356543.57|1291769800:1317337073.24|77650192:1317420674.31|1129674912:1317334895.1|1138778952:1317321323.3"
        #print ids + " are the IDs"
        #self.setFilterString(re.sub(' ', '|', self.__filterStr))
        self.setFilterCol(4)
        self.applyFilter()
        #self.model.proxy.setFilterRegExp(QRegExp(ids, Qt.CaseInsensitive))
        #self.model.proxy.setFilterKeyColumn(4);
        self.parent.sortModel()
        self.parent.scrollToSelection()
        
    def clearViewSelections(self):
        del self.viewSelectedCategories[:]
        del self.viewSelectedCategoriesElements[:]
        del self.viewSelectedCategoryItemIds[:]
        #if we got this far clear the categorizables cause we're changing them anyway
        self.__filterStr = ""
        
    def addViewCategory(self, element):
        try:
            element.attrib["id"]
        except KeyError:
            #Just a closing tag, not a valid task
            pass
        else:
            #print element.attrib["id"]
            self.viewSelectedCategories.append(element.attrib["id"])
            self.viewSelectedCategoriesElements.append(element)
            self.addCategorizables(element)
            
            
    def addCategorizables(self, element):
        #get categorizable ids for self.viewSelectedCategoryItemIds
        try:
            element.attrib["categorizables"]
        except KeyError:
            #nothing in this category
            pass
        else:
            #self.viewSelectedCategoryItemIds.append(element.attrib["categorizables"])
            list = element.attrib["categorizables"].split()
            #print list
            
            #For filtering using QSortFilterProxy model
            if self.__filterStr == "":
                self.__filterStr = element.attrib["categorizables"]
            else:
                self.__filterStr = self.__filterStr + " " + element.attrib["categorizables"]
            #print self.__filterStr
            
            for id in range(0, len(list)):
                self.viewSelectedCategoryItemIds.append(list[id])
                #print list[id]
    
    def refreshFilter(self):
        #Clear current list
        self.__filterStr = ""
        #Add all categorizables from elements in filter
        for element in self.viewSelectedCategoriesElements:
            self.addCategorizables(element)
        self.applyFilter()
