#ifndef __SYMB_H__
#define __SYMB_H__

#include "object.h"

/* Compile algeraic expr (CSTR) into (SYMB) */
T_SYMB* symb_parse(const char *word); // OK

/* Convert (SYMB) into (CSTR) */
char* symb_expr(const T_SYMB *symb); // OK

/* Convert algebraic expr (CSTR) into tokenized stream (PROG) */
T_ATOM* parse_expr(const char *word); // OK

/* Convert (PROG) into (SYMB) */
T_SYMB *symb_gen(const T_CONS *rpn); // OK

/* Convert tokenized stream (PROG) into postfix (PROG)*/
T_ATOM* symb_eval(T_ATOM *stream); // OK

/* Convert (SYMB) into (PROG) */
T_ATOM* symb_rpn(const T_SYMB *symb); // OK

/* Copy */
T_SYMB *symb_copy(const T_SYMB *symb);

/* Test */
int symb_q_zero(const T_SYMB *symb);
int symb_q_one(const T_SYMB *symb);
 
/* Simplify */
T_ATOM* symb_simplify(const T_ATOM *ob);

#endif
