#ifndef __STACK_H__
#define __STACK_H__

#include "object.h"

#include <sys/types.h>
#include <stdio.h>
#include <curses.h>

/* Data Stack := LIFO linked list of pointers to ISTK objects */
extern T_CONS *DSTK;

/* Return Stack := LIFO linked list of pointers to ISTK objects */

#define RSTK_MAX  16
#define LOOP_MAX 128

extern T_CONS *RSTK[RSTK_MAX], *ISTK[RSTK_MAX], *IPTR;
extern int RSTK_LEVEL, ISTK_LEVEL;

/* Loop Stack */

typedef struct {
  signed long int Index, Stop;
} T_LOOP;

extern T_LOOP LOOP[LOOP_MAX];
extern int LOOP_LEVEL;

/* Macro */

#define __peek_type(l) atom_q_type(DSTK_peek(l))

#define __peek_bint() (DSTK_CK1(NULL, BINT) ? atom_get_bint(DSTK->car) : 0)
#define __peek_real() (DSTK_CK1(NULL, REAL) ? atom_get_real(DSTK->car) : 0)

#define __push_bint(x)     DSTK_add(atom_make_bint(x))
#define __push_zint(z)     DSTK_add(atom_make_zint(z))
#define __push_flag(q)     DSTK_add(atom_make_flag(q))
#define __push_cplx(z)     DSTK_add(atom_make_cplx(z.x, z.y))
#define __push_cplx2(x, y) DSTK_add(atom_make_cplx(x, y))
#define __push_real(x)     DSTK_add(atom_make_real(x))

/* Exported */

void    DSTK_add(T_ATOM *);
void    DSTK_dup(void);
void    DSTK_drop(void);
void    DSTK_swap(void);
void    DSTK_roll(size_t level);
void    DSTK_unroll(size_t level);
T_ATOM *DSTK_peek(size_t level);
T_ATOM *DSTK_pop(void);
void    DSTK_dump(WINDOW *stream);

void    ISTK_dump(WINDOW *stream, const T_CONS *rs);

void    ISTK_add(T_CONS *rs);
void    ISTK_kill(void);

void    RSTK_dup(void);
void    RSTK_pop(void);
T_CONS *RSTK_peek(void);
void    RSTK_dump(void);

void    LOOP_add(signed long int Index, signed long int Stop);
void    LOOP_drop(void);

signed long int LOOP_Index(size_t level);
signed long int LOOP_Stop(size_t level);

void    STK_add(T_CONS **, T_ATOM *);
void    STK_drop(T_CONS **);
T_ATOM *STK_peek(const T_CONS *, size_t level);
T_ATOM *STK_pop(T_CONS **);
size_t  STK_depth(const T_CONS *);
void    STK_dump(T_CONS *, WINDOW *);

int DSTK_CK1(T_ATOM *self, size_t T1);
int DSTK_CK2(T_ATOM *self, size_t T2, size_t T1);
int DSTK_CK3(T_ATOM *self, size_t T3, size_t T2, size_t T1);
int DSTK_CKN(T_ATOM *self);
int DSTK_CKANY(T_ATOM *self, size_t N);

T_BINT __pop_bint(T_BINT *);
void   __pop_zint(T_ZINT *);
T_BINT __pop_flag(T_BINT *);
T_CPLX __pop_cplx(T_CPLX *);
T_REAL __pop_real(T_REAL *);

#endif
